/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.vault.VaultEntry;
import de.mhus.lib.core.vault.VaultSource;
import de.mhus.lib.errors.NotSupportedException;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;

public abstract class MutableVaultSource
extends MLog
implements VaultSource {
    protected HashMap<UUID, VaultEntry> entries = new HashMap();
    protected String name = UUID.randomUUID().toString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VaultEntry getEntry(UUID id) {
        HashMap<UUID, VaultEntry> hashMap = this.entries;
        synchronized (hashMap) {
            return this.entries.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UUID[] getEntryIds() {
        HashMap<UUID, VaultEntry> hashMap = this.entries;
        synchronized (hashMap) {
            return this.entries.keySet().toArray(new UUID[this.entries.size()]);
        }
    }

    @Override
    public <T> T adaptTo(Class<? extends T> ifc) throws NotSupportedException {
        if (ifc.isInstance(this)) {
            return (T)this;
        }
        throw new NotSupportedException(new Object[]{this, ifc});
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(VaultEntry entry) {
        HashMap<UUID, VaultEntry> hashMap = this.entries;
        synchronized (hashMap) {
            this.entries.put(entry.getId(), entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(UUID id) {
        HashMap<UUID, VaultEntry> hashMap = this.entries;
        synchronized (hashMap) {
            this.entries.remove(id);
        }
    }

    public abstract void doLoad() throws IOException;

    public abstract void doSave() throws IOException;

    public String toString() {
        return MSystem.toString(this, this.name, this.entries.size());
    }
}

