/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.vault;

import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.crypt.AsyncKey;
import de.mhus.lib.core.crypt.MCrypt;
import de.mhus.lib.core.crypt.pem.PemPriv;
import de.mhus.lib.core.crypt.pem.PemPub;
import de.mhus.lib.core.crypt.pem.PemUtil;
import de.mhus.lib.core.parser.ParseException;
import de.mhus.lib.core.util.SecureString;
import de.mhus.lib.core.vault.VaultEntry;
import de.mhus.lib.errors.NotSupportedException;
import java.util.UUID;

public class DefaultEntry
implements VaultEntry {
    protected UUID id = UUID.randomUUID();
    protected String type;
    protected String description;
    protected SecureString value;

    public DefaultEntry() {
    }

    public DefaultEntry(UUID id, String type, String description, String value) {
        this(type, description, value);
        this.id = id;
    }

    public DefaultEntry(String type, String description, String value) {
        this.type = type;
        this.description = description;
        this.value = new SecureString(value);
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getValue() {
        return this.value.value();
    }

    @Override
    public <T> T adaptTo(Class<? extends T> ifc) throws ParseException, NotSupportedException {
        if (this.getType() != null) {
            try {
                if (ifc == AsyncKey.class && "rsa.cipher.private.key".equals(this.getType())) {
                    return (T)MCrypt.loadPrivateRsaKey(this.getValue());
                }
                if (ifc == AsyncKey.class && "rsa.cipher.public.key".equals(this.type)) {
                    return (T)MCrypt.loadPrivateRsaKey(this.getValue());
                }
                if (ifc == PemPriv.class && this.getType().endsWith(".cipher.private.key")) {
                    return (T)PemUtil.cipherPrivFromString(this.getValue());
                }
                if (ifc == PemPub.class && this.getType().endsWith(".cipher.public.key")) {
                    return (T)PemUtil.cipherPubFromString(this.getValue());
                }
                if (ifc == PemPriv.class && this.getType().endsWith(".sign.private.key")) {
                    return (T)PemUtil.signPrivFromString(this.getValue());
                }
                if (ifc == PemPub.class && this.getType().endsWith(".sign.public.key")) {
                    return (T)PemUtil.signPubFromString(this.getValue());
                }
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
        throw new NotSupportedException(new Object[]{this, ifc});
    }

    public String toString() {
        return MSystem.toString(this, this.id, this.type);
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

