/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import java.util.Observable;
import java.util.Observer;
import java.util.WeakHashMap;

public class WeakObservable
extends Observable {
    private boolean changed = false;
    private WeakHashMap<Observer, String> obs = new WeakHashMap();

    @Override
    public synchronized void addObserver(Observer o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!this.obs.containsKey(o)) {
            this.obs.put(o, "");
        }
    }

    @Override
    public synchronized void deleteObserver(Observer o) {
        this.obs.remove(o);
    }

    @Override
    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyObservers(Object arg) {
        Object[] arrLocal;
        WeakObservable weakObservable = this;
        synchronized (weakObservable) {
            if (!this.changed) {
                return;
            }
            arrLocal = this.obs.keySet().toArray();
            this.clearChanged();
        }
        for (int i = arrLocal.length - 1; i >= 0; --i) {
            ((Observer)arrLocal[i]).update(this, arg);
        }
    }

    @Override
    public synchronized void deleteObservers() {
        this.obs.clear();
    }

    @Override
    public synchronized void setChanged() {
        this.changed = true;
    }

    @Override
    protected synchronized void clearChanged() {
        this.changed = false;
    }

    @Override
    public synchronized boolean hasChanged() {
        return this.changed;
    }

    @Override
    public synchronized int countObservers() {
        return this.obs.size();
    }
}

