/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.pojo.DefaultFilter;
import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.core.pojo.PojoModel;
import de.mhus.lib.core.pojo.PojoParser;

public class Stringifier {
    private Object from;
    private String str;
    private int level;

    public Stringifier(Object in) {
        this(in, 1);
    }

    public Stringifier(Object in, int level) {
        this.from = in;
        this.level = level;
    }

    public synchronized String toString() {
        if (this.str == null) {
            this.str = this.doStringify(this.from, 0);
        }
        return this.str;
    }

    private String doStringify(Object in, int level) {
        if (in == null) {
            return "null";
        }
        if (level >= this.level) {
            return in.toString();
        }
        StringBuffer out = new StringBuffer();
        out.append('{');
        try {
            out.append(in.getClass()).append(':');
            PojoModel model = new PojoParser().parse(in, "_", null).filter(new DefaultFilter(true, false, true, true, true)).getModel();
            boolean first = true;
            for (PojoAttribute attr : model) {
                if (first) {
                    first = false;
                } else {
                    out.append(',');
                }
                try {
                    out.append(attr.getName()).append('=').append(this.doStringify(attr.get(in), level + 1));
                }
                catch (Throwable t) {
                    out.append(t.toString());
                }
            }
        }
        catch (Throwable t) {
            out.append(t.toString());
        }
        out.append('}');
        return out.toString();
    }

    public static void stringifyArray(Object[] in) {
        if (in == null) {
            return;
        }
        for (int i = 0; i < in.length; ++i) {
            in[i] = Stringifier.stringifyWrap(in[i]);
        }
    }

    public static Object stringifyWrap(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        if (c.isPrimitive() || o instanceof String) {
            return o;
        }
        String cn = c.getName();
        if (cn.startsWith("java") || cn.startsWith("javax")) {
            return o;
        }
        return new Stringifier(o);
    }
}

