/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.util.EmptySet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class FilterRequest {
    private Map<String, String> facets;
    private String[] text;

    public FilterRequest(String[] text, Map<String, String> facets) {
        this.text = text;
        this.facets = facets;
    }

    public FilterRequest(String text) {
        if (text == null) {
            return;
        }
        LinkedList<String> lText = new LinkedList<String>();
        this.facets = new HashMap<String, String>();
        for (String part : text.split(" ")) {
            if (!MString.isSet(part = part.trim())) continue;
            if (part.indexOf(58) > 0) {
                this.facets.put(MString.beforeIndex(part, ':'), MString.afterIndex(part, ':'));
                continue;
            }
            lText.add(part);
        }
        this.text = lText.toArray(new String[lText.size()]);
    }

    public String[] getGeneralFilters() {
        if (this.text == null) {
            return new String[0];
        }
        return this.text;
    }

    public boolean isFiltering() {
        return this.text != null && this.text.length > 0 || this.facets != null && this.facets.size() > 0;
    }

    public String getFacet(String name) {
        if (this.facets == null) {
            return null;
        }
        return this.facets.get(name);
    }

    public Set<String> getFacetKeys() {
        if (this.facets == null) {
            return new EmptySet<String>();
        }
        return this.facets.keySet();
    }
}

