/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.system;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.cfg.CfgInitiator;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.PropertiesConfig;
import de.mhus.lib.core.logging.ConsoleFactory;
import de.mhus.lib.core.logging.LevelMapper;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.LogFactory;
import de.mhus.lib.core.logging.MLogFactory;
import de.mhus.lib.core.logging.MutableParameterMapper;
import de.mhus.lib.core.logging.ParameterEntryMapper;
import de.mhus.lib.core.logging.ParameterMapper;
import de.mhus.lib.core.system.CfgManager;
import de.mhus.lib.core.system.IApiInternal;
import de.mhus.lib.core.system.SecureStreamToLogAdapter;
import java.io.PrintStream;
import java.util.Collection;

public class LogCfgInitiator
implements CfgInitiator {
    private static PrintStream err = System.err;
    private static PrintStream out = System.out;

    @Override
    public void doInitialize(IApiInternal internal, CfgManager manager) {
        Object name;
        String key;
        IConfig system = manager.getCfg("system");
        if (system == null) {
            system = new PropertiesConfig();
        }
        internal.getLogTrace().clear();
        for (String p : system.getPropertyKeys()) {
            if (!p.startsWith("TRACE.")) continue;
            internal.getLogTrace().add(p.substring(6));
        }
        MLogFactory mlogFactory = null;
        try {
            String key2 = "log.mlog.factory";
            String name2 = system.getString(key2);
            if (MString.isEmpty(name2)) {
                name2 = System.getProperty("mhus.lib." + key2);
            }
            if (MString.isSet(name2)) {
                mlogFactory = (MLogFactory)Class.forName(name2.trim()).newInstance();
            }
        }
        catch (Throwable t) {
            MApi.dirtyLog(t);
        }
        if (mlogFactory != null) {
            internal.setMLogFactory(mlogFactory);
        }
        LogFactory logFactory = null;
        try {
            key = "log.factory";
            name = system.getString(key);
            if (MString.isEmpty((String)name)) {
                name = System.getProperty("mhus.lib." + key);
            }
            if (MString.isSet((String)name)) {
                logFactory = (LogFactory)Class.forName(((String)name).trim()).newInstance();
            }
        }
        catch (Throwable t) {
            MApi.dirtyLog(t);
        }
        if (logFactory == null) {
            logFactory = new ConsoleFactory();
        }
        try {
            key = "level.mapper";
            name = system.getString(key);
            if (MString.isEmpty((String)name)) {
                name = System.getProperty("mhus.lib." + key);
            }
            if (MString.isSet((String)name)) {
                logFactory.setLevelMapper((LevelMapper)Class.forName(((String)name).trim()).newInstance());
            }
        }
        catch (Throwable t) {
            MApi.dirtyLog(t);
        }
        try {
            key = "log.max.message.size";
            String size = system.getString(key);
            if (size != null) {
                logFactory.setMaxMessageSize(Integer.valueOf(size));
            }
        }
        catch (Throwable t) {
            MApi.dirtyLog(t);
        }
        try {
            key = "parameter.mapper";
            name = system.getString(key);
            if (MString.isEmpty((String)name)) {
                name = System.getProperty("mhus.lib." + key);
            }
            if (MString.isSet((String)name)) {
                logFactory.setParameterMapper((ParameterMapper)Class.forName(((String)name).trim()).newInstance());
            }
        }
        catch (Throwable t) {
            MApi.dirtyLog(t);
        }
        if (logFactory.getParameterMapper() != null && logFactory.getParameterMapper() instanceof MutableParameterMapper) {
            try {
                Collection mappers = system.getNodes("parameter.mapper");
                if (mappers.size() > 0) {
                    ((MutableParameterMapper)((Object)logFactory.getParameterMapper())).clear();
                }
                for (IConfig mapper : mappers) {
                    String name3 = mapper.getString("name");
                    String clazz = mapper.getString("class");
                    if (!MString.isSet(name3) || !MString.isSet(clazz)) continue;
                    ((MutableParameterMapper)((Object)logFactory.getParameterMapper())).put(name3, (ParameterEntryMapper)Class.forName(clazz.trim()).newInstance());
                }
            }
            catch (Throwable t) {
                MApi.dirtyLog(t);
            }
        }
        try {
            key = "log.console.redirect";
            name = system.getString(key);
            if (MString.isEmpty((String)name)) {
                name = System.getProperty("mhus.lib." + key);
            }
            if (MString.isSet((String)name) && "true".equals(name)) {
                System.setErr(new SecureStreamToLogAdapter(Log.LEVEL.ERROR, err));
                System.setOut(new SecureStreamToLogAdapter(Log.LEVEL.INFO, out));
            }
        }
        catch (Throwable t) {
            MApi.dirtyLog(t);
        }
        try {
            key = "log.level";
            String value = system.getString(key);
            if (MString.isEmpty(value)) {
                value = System.getProperty("mhus.lib." + key);
            }
            if (MString.isSet(value)) {
                logFactory.setDefaultLevel(Log.LEVEL.valueOf(value.toUpperCase()));
            }
        }
        catch (Throwable t) {
            MApi.dirtyLog(t);
        }
        internal.setLogFactory(logFactory);
        MApi.updateLoggers();
    }
}

