/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.schedule;

import de.mhus.lib.basics.Named;
import de.mhus.lib.core.ITimerTask;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.MTimerTask;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.core.schedule.Scheduler;
import de.mhus.lib.core.schedule.TimerTaskIntercepter;
import de.mhus.lib.core.strategy.DefaultTaskContext;
import de.mhus.lib.core.strategy.NotSuccessful;
import de.mhus.lib.core.strategy.Operation;
import de.mhus.lib.core.strategy.OperationDescription;
import de.mhus.lib.core.strategy.OperationResult;
import de.mhus.lib.core.strategy.TaskContext;
import de.mhus.lib.core.util.MNls;

public abstract class SchedulerJob
extends MTimerTask
implements Operation {
    public static final long CALCULATE_NEXT = 0L;
    public static final long DISABLED_TIME = -1L;
    public static final long REMOVE_TIME = -2L;
    protected static Log log = Log.getLog(SchedulerJob.class);
    private Object owner;
    private long nextExecutionTime = 0L;
    protected MyTaskContext context = new MyTaskContext();
    private boolean done = false;
    private ITimerTask task;
    private long lastExecutionStart;
    private long lastExecutionStop;
    private long scheduledTime;
    private long timeoutInMinutes;
    private Thread thread;
    private MNls nls;
    private String info;
    private TimerTaskIntercepter intercepter;
    private String logTrailConfig;

    public SchedulerJob(ITimerTask task) {
        this.setTask(task);
        if (task == null) {
            this.setName("null");
        }
        if (task instanceof Named) {
            this.setName(task.getName());
        } else {
            this.setName(MSystem.getClassName(task));
        }
    }

    public SchedulerJob(String name, ITimerTask task) {
        this.setTask(task);
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTick(boolean forced) {
        block22: {
            if (!forced) {
                if (!this.isCanceled() && this.task instanceof MTimerTask && ((MTimerTask)this.task).isCanceled()) {
                    log.i("doTick canceled 1", this.getName(), this.task);
                    this.cancel();
                }
                if (this.isCanceled()) {
                    log.i("doTick canceled 2", this.getName(), this.task);
                    return;
                }
                if (this.getNextExecutionTime() == 0L) {
                    SchedulerJob schedulerJob = this;
                    synchronized (schedulerJob) {
                        this.doCaclulateNextExecution();
                    }
                }
            }
            if (forced || this.isExecutionTimeReached()) {
                boolean logConfigReset = false;
                if (this.getLogTrailConfig() != null) {
                    MLogUtil.setTrailConfig(this.getLogTrailConfig());
                    logConfigReset = true;
                }
                try {
                    boolean doIt = true;
                    if (this.intercepter != null) {
                        log.d("Intercepter beforeExecution", this.getName());
                        doIt = this.intercepter.beforeExecution(this, this.context, forced);
                    }
                    if (doIt) {
                        block21: {
                            this.thread = Thread.currentThread();
                            this.lastExecutionStart = System.currentTimeMillis();
                            try {
                                this.doExecute(this.context);
                            }
                            catch (Throwable e) {
                                log.d("Error", this.getName(), e);
                                this.doError(e);
                                if (this.intercepter == null) break block21;
                                this.intercepter.onError(this, this.context, e);
                            }
                        }
                        this.lastExecutionStop = System.currentTimeMillis();
                        if (this.intercepter != null) {
                            log.d("Intercepter afterExecution", this.getName());
                            this.intercepter.afterExecution(this, this.context);
                        }
                        this.thread = null;
                    }
                    this.context.clear();
                    this.setDone(true);
                    SchedulerJob schedulerJob = this;
                    synchronized (schedulerJob) {
                        this.doCaclulateNextExecution();
                        log.d("Scheduled to", this.getName(), this.getNextExecutionTime());
                        break block22;
                    }
                }
                finally {
                    if (logConfigReset) {
                        MLogUtil.releaseTrailConfig();
                    }
                }
            }
            log.i("Execution delayed", this.task);
        }
    }

    protected abstract void doCaclulateNextExecution();

    @Override
    public final OperationResult doExecute(TaskContext context) throws Exception {
        log.d("execute", this.getClass(), context.getParameters());
        if (!this.hasAccess()) {
            log.d("access denied", context, context.getErrorMessage());
            return new NotSuccessful(this, "access denied", -401L);
        }
        if (!this.canExecute(context)) {
            log.d("execution denied", context.getErrorMessage());
            return new NotSuccessful(this, context.getErrorMessage() != null ? context.getErrorMessage() : "can't execute", -12L);
        }
        OperationResult ret = this.doExecute2(context);
        log.t("result", this.getClass(), ret);
        return ret;
    }

    protected OperationResult doExecute2(TaskContext context) throws Exception {
        try {
            if (this.task != null) {
                this.task.run(context);
            }
        }
        catch (LinkageError le) {
            log.d("cancel task because of fatal errors", this, le);
            this.cancel();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBusy() {
        SchedulerJob schedulerJob = this;
        synchronized (schedulerJob) {
            return this.owner != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBusy(Object owner) {
        SchedulerJob schedulerJob = this;
        synchronized (schedulerJob) {
            if (this.owner != null) {
                return false;
            }
            this.owner = owner;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseBusy(Object owner) {
        SchedulerJob schedulerJob = this;
        synchronized (schedulerJob) {
            if (this.owner == null) {
                return true;
            }
            if (owner == null) {
                this.owner = null;
                return true;
            }
            if (this.owner != owner) {
                return false;
            }
            this.owner = null;
        }
        return true;
    }

    public Object getOwner() {
        return this.owner;
    }

    protected boolean isExecutionTimeReached() {
        return this.getNextExecutionTime() > 0L && System.currentTimeMillis() >= this.getNextExecutionTime();
    }

    public boolean isDone() {
        return this.done;
    }

    protected void setDone(boolean done) {
        this.done = done;
    }

    @Override
    public boolean hasAccess() {
        return true;
    }

    @Override
    public boolean canExecute(TaskContext context) {
        return true;
    }

    @Override
    public OperationDescription getDescription() {
        return null;
    }

    public ITimerTask getTask() {
        return this.task;
    }

    protected void setTask(ITimerTask task) {
        this.task = task;
    }

    @Override
    public void doit() throws Exception {
        this.doTick(false);
    }

    public long getNextExecutionTime() {
        return this.nextExecutionTime;
    }

    protected void doError(Throwable t) {
        log.e(this.getName(), t);
    }

    protected void doSchedule(Scheduler scheduler) {
        this.doReschedule(scheduler, this.getNextExecutionTime());
    }

    protected void doReschedule(Scheduler scheduler, long time) {
        this.setNextExecutionTime(time);
        if (this.isCanceled()) {
            return;
        }
        if (this.getNextExecutionTime() == 0L) {
            this.doCaclulateNextExecution();
        }
        if (this.getNextExecutionTime() == -2L) {
            return;
        }
        if (this.getNextExecutionTime() == -1L) {
            this.setScheduledTime(System.currentTimeMillis() + 86400000L);
            scheduler.getQueue().removeJob(this);
            scheduler.getQueue().doSchedule(this);
            return;
        }
        this.setScheduledTime(this.getNextExecutionTime());
        scheduler.getQueue().removeJob(this);
        scheduler.getQueue().doSchedule(this);
    }

    public long getLastExecutionStart() {
        return this.lastExecutionStart;
    }

    public long getLastExecutionStop() {
        return this.lastExecutionStop;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    protected void setScheduledTime(long scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public long getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public void setTimeoutInMinutes(long timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public void doTimeoutReached() {
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setNextExecutionTime(long nextExecutionTime) {
        this.nextExecutionTime = nextExecutionTime;
    }

    @Override
    public MNls getNls() {
        if (this.nls == null) {
            this.nls = MNls.lookup(this);
        }
        return this.nls;
    }

    @Override
    public String nls(String text) {
        return MNls.find(this, text);
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public TimerTaskIntercepter getIntercepter() {
        return this.intercepter;
    }

    public void setIntercepter(TimerTaskIntercepter intercepter) {
        this.intercepter = intercepter;
        if (intercepter != null) {
            intercepter.initialize(this);
        }
    }

    public String getLogTrailConfig() {
        return this.logTrailConfig;
    }

    public void setLogTrailConfig(String logTrailConfig) {
        this.logTrailConfig = logTrailConfig;
    }

    protected static class MyTaskContext
    extends DefaultTaskContext {
        public MyTaskContext() {
            super(SchedulerJob.class);
        }

        public void clear() {
            this.errorMessage = null;
        }
    }
}

