/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.schedule;

import de.mhus.lib.basics.Named;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MThread;
import de.mhus.lib.core.MTimeInterval;
import de.mhus.lib.core.schedule.QueueList;
import de.mhus.lib.core.schedule.SchedulerJob;
import de.mhus.lib.core.schedule.SchedulerQueue;
import java.util.AbstractCollection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class Scheduler
extends MLog
implements Named {
    private Timer timer;
    SchedulerQueue queue = new QueueList();
    private String name = Scheduler.class.getCanonicalName();
    private LinkedList<SchedulerJob> running = new LinkedList();
    private HashSet<SchedulerJob> jobs = new HashSet();
    private long nextTimeoutCheck;
    private long lastQueueCheck = System.currentTimeMillis();
    private long queueCheckTimeout = 60000L;

    public Scheduler() {
    }

    public Scheduler(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void start() {
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer(this.name, true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Scheduler.this.doTick();
            }
        }, 1000L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTick() {
        HashSet<SchedulerJob> hashSet = this.jobs;
        synchronized (hashSet) {
            List<SchedulerJob> pack;
            if (MTimeInterval.isTimeOut(this.lastQueueCheck, this.queueCheckTimeout)) {
                this.doQueueCheck();
            }
            if ((pack = this.queue.removeJobs(System.currentTimeMillis())) != null) {
                for (SchedulerJob job : pack) {
                    try {
                        this.doExecuteJob(job, false);
                    }
                    catch (Throwable t) {
                        this.log().t("Job error", job.getName(), job, t);
                        job.doError(t);
                    }
                }
            }
        }
        long time = System.currentTimeMillis();
        if (this.nextTimeoutCheck < time) {
            try {
                for (SchedulerJob job : this.running) {
                    long timeout = job.getTimeoutInMinutes() * 60000L;
                    if (timeout <= 0L || timeout + job.getLastExecutionStart() > time) continue;
                    try {
                        if (!job.isBusy()) continue;
                        this.log().d("job timeout", job.getName());
                        job.doTimeoutReached();
                    }
                    catch (Throwable t) {
                        job.doError(t);
                    }
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            this.nextTimeoutCheck = time + 60000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecuteJob(SchedulerJob job, boolean forced) {
        if (!job.setBusy(this)) {
            this.log().w("job is busy, reshedule", job.getName());
            boolean isRunning = false;
            LinkedList<SchedulerJob> linkedList = this.running;
            synchronized (linkedList) {
                isRunning = this.running.contains(job);
            }
            try {
                if (!isRunning) {
                    this.log().w("release job lock", job.getName());
                    job.releaseBusy(null);
                } else {
                    this.log().w("found a running job in the scheduler queue", job.getName());
                    job.setNextExecutionTime(0L);
                    job.doSchedule(this);
                }
            }
            catch (Throwable t) {
                this.log().e("busy error", job.getName(), job, t);
            }
            return;
        }
        new MThread(new MyExecutor(job, forced)).start();
    }

    public void stop() {
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SchedulerJob job) {
        SchedulerJob schedulerJob = job;
        synchronized (schedulerJob) {
            this.jobs.add(job);
        }
        job.doSchedule(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doQueueCheck() {
        this.log().d("doQueueCheck");
        this.lastQueueCheck = System.currentTimeMillis();
        LinkedList<SchedulerJob> linkedList = this.running;
        synchronized (linkedList) {
            HashSet<SchedulerJob> hashSet = this.jobs;
            synchronized (hashSet) {
                this.jobs.removeIf(j -> j.isCanceled());
                this.jobs.forEach(j -> {
                    if (!this.queue.contains((SchedulerJob)j) && !this.running.contains(j)) {
                        try {
                            this.log().w("reschedule lost job", j.getName());
                            j.setNextExecutionTime(0L);
                            j.doSchedule(this);
                        }
                        catch (Throwable t) {
                            this.log().w("reschedule failed", j, t);
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SchedulerJob> getRunningJobs() {
        LinkedList<SchedulerJob> linkedList = this.running;
        synchronized (linkedList) {
            return new LinkedList<SchedulerJob>(this.running);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SchedulerJob> getJobs() {
        HashSet<SchedulerJob> hashSet = this.jobs;
        synchronized (hashSet) {
            return new LinkedList<SchedulerJob>(this.jobs);
        }
    }

    public List<SchedulerJob> getScheduledJobs() {
        return this.queue.getJobs();
    }

    public SchedulerQueue getQueue() {
        return this.queue;
    }

    private class MyExecutor
    implements Runnable {
        private SchedulerJob job;
        private boolean forced;

        public MyExecutor(SchedulerJob job, boolean forced) {
            this.job = job;
            this.forced = forced;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block24: {
                Scheduler.this.log().d("Job started", this.job.getName());
                LinkedList linkedList = Scheduler.this.running;
                synchronized (linkedList) {
                    Scheduler.this.running.add(this.job);
                }
                try {
                    if (this.job != null && !this.job.isCanceled()) {
                        Scheduler.this.log().d(">>> Tick", this.job.getName());
                        this.job.doTick(this.forced);
                        Scheduler.this.log().d("<<< Tick", this.job.getName());
                    } else {
                        Scheduler.this.log().i("Job canceled", this.job.getName());
                    }
                }
                catch (Throwable t) {
                    try {
                        this.job.doError(t);
                    }
                    catch (Throwable t2) {
                        try {
                            Scheduler.this.log().w("Error t2", this.job.getName(), t2);
                        }
                        catch (Throwable t3) {
                            t3.printStackTrace();
                        }
                    }
                }
                AbstractCollection t = Scheduler.this.running;
                synchronized (t) {
                    try {
                        if (!this.job.releaseBusy(Scheduler.this)) {
                            Scheduler.this.log().w("Job release not possible, do hard release", this.job.getName());
                            this.job.releaseBusy(null);
                        }
                        Scheduler.this.running.remove(this.job);
                    }
                    catch (Throwable t1) {
                        Scheduler.this.log().f("Error t1", this.job.getName(), t1);
                    }
                    try {
                        this.job.doSchedule(Scheduler.this);
                    }
                    catch (Throwable t2) {
                        Scheduler.this.log().f("Can't reschedule", this.job.getName(), t2);
                    }
                }
                try {
                    if (!this.job.isCanceled()) break block24;
                    t = Scheduler.this.jobs;
                    synchronized (t) {
                        Scheduler.this.jobs.remove(this.job);
                    }
                }
                catch (Throwable t3) {
                    Scheduler.this.log().f("Error t3", this.job.getName(), t3);
                }
            }
        }
    }
}

