/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.lang;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;

public class DelegateClassLoader
extends ClassLoader {
    private LinkedList<Package> list = new LinkedList();

    public DelegateClassLoader() {
    }

    public DelegateClassLoader(ClassLoader parent) {
        super(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(ClassLoader loader) {
        LinkedList<Package> linkedList = this.list;
        synchronized (linkedList) {
            this.list.add(new Package(loader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<Package> linkedList = this.list;
        synchronized (linkedList) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        LinkedList<Package> linkedList = this.list;
        synchronized (linkedList) {
            for (Package p : this.list) {
                Class<?> clazz = p.loadClass(name, resolve);
                if (clazz == null) continue;
                return clazz;
            }
        }
        return super.loadClass(name, resolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        LinkedList<Package> linkedList = this.list;
        synchronized (linkedList) {
            for (Package p : this.list) {
                URL out = p.getResource(name);
                if (out == null) continue;
                return out;
            }
        }
        return super.getResource(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String name) {
        LinkedList<Package> linkedList = this.list;
        synchronized (linkedList) {
            for (Package p : this.list) {
                InputStream out = p.getResourceAsStream(name);
                if (out == null) continue;
                return out;
            }
        }
        return super.getResourceAsStream(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedList<Package> linkedList = this.list;
        synchronized (linkedList) {
            for (Package p : this.list) {
                Enumeration<URL> out = p.getResources(name);
                if (out == null) continue;
                return out;
            }
        }
        return super.getResources(name);
    }

    private class Package {
        private ClassLoader loader;

        public Package(ClassLoader loader) {
            this.loader = loader;
        }

        public Class<?> loadClass(String name, boolean resolve) {
            try {
                return this.loader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        public URL getResource(String name) {
            return this.loader.getResource(name);
        }

        public InputStream getResourceAsStream(String name) {
            return this.loader.getResourceAsStream(name);
        }

        public Enumeration<URL> getResources(String name) {
            try {
                return this.loader.getResources(name);
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

