/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.json;

import de.mhus.lib.core.MJson;
import de.mhus.lib.core.json.TransformStrategy;
import de.mhus.lib.core.pojo.DefaultFilter;
import de.mhus.lib.core.pojo.PojoModel;
import de.mhus.lib.core.pojo.PojoParser;
import java.lang.reflect.Array;
import org.codehaus.jackson.JsonNode;

public class TransformHelper {
    int level = 0;
    protected String prefix = "";
    protected TransformStrategy strategy = MJson.DEFAULT_STRATEGY;

    public TransformHelper incLevel() {
        ++this.level;
        return this;
    }

    public void postToJson(Object from, JsonNode to) {
    }

    public Class<?> getType(String clazz) throws IllegalAccessException {
        try {
            if (clazz.endsWith("[]")) {
                clazz = clazz.substring(0, clazz.length() - 2);
            }
            switch (clazz) {
                case "byte": {
                    return Byte.TYPE;
                }
                case "int": {
                    return Integer.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
            }
            return this.getClassLoader().loadClass(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isArrayType(String type) {
        return type.endsWith("[]");
    }

    public ClassLoader getClassLoader() {
        return TransformHelper.class.getClassLoader();
    }

    public TransformHelper decLevel() {
        --this.level;
        return this;
    }

    public Object createObject(Class<?> type) throws InstantiationException, IllegalAccessException {
        return type.newInstance();
    }

    public void log(String string, Throwable t) {
        System.out.println(string);
        t.printStackTrace();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String in) {
        this.prefix = in;
    }

    public PojoModel createPojoModel(Object from) {
        PojoModel model = new PojoParser().parse(from, "_", null).filter(new DefaultFilter(true, false, true, true, true)).getModel();
        return model;
    }

    public void log(String msg) {
        System.out.println(msg);
    }

    public boolean checkLevel() {
        return this.level < 10;
    }

    public Object createArray(int length, Class<?> type) {
        return Array.newInstance(type, length);
    }

    public TransformStrategy getStrategy() {
        return this.strategy;
    }

    public void postToPojo(JsonNode from, Object to) {
    }
}

