/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io.http;

import de.mhus.lib.core.io.http.MHttpClientBuilder;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;

public class InsecureHttpClientBuilder
extends MHttpClientBuilder {
    private DnsResolver dnsResolver;
    private long connTimeToLive = -1L;
    private TimeUnit connTimeToLiveTimeUnit = TimeUnit.MILLISECONDS;
    private SocketConfig defaultSocketConfig;
    private ConnectionConfig defaultConnectionConfig;

    @Override
    protected void configureProtocolHandling(HttpClientBuilder build) {
        super.configureProtocolHandling(build);
        SSLConnectionSocketFactory sslSocketFactory = this.buildSSLSocketFactory();
        PoolingHttpClientConnectionManager poolingManager = new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build(), null, null, this.dnsResolver, this.connTimeToLive, this.connTimeToLiveTimeUnit != null ? this.connTimeToLiveTimeUnit : TimeUnit.MILLISECONDS);
        if (this.defaultSocketConfig != null) {
            poolingManager.setDefaultSocketConfig(this.defaultSocketConfig);
        }
        if (this.defaultConnectionConfig != null) {
            poolingManager.setDefaultConnectionConfig(this.defaultConnectionConfig);
        }
        build.setConnectionManager((HttpClientConnectionManager)poolingManager);
    }

    protected SSLConnectionSocketFactory buildSSLSocketFactory() {
        HostnameVerifier hostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(SSLContexts.createDefault(), hostnameVerifier);
        return sslSocketFactory;
    }

    public DnsResolver getDnsResolver() {
        return this.dnsResolver;
    }

    public void setDnsResolver(DnsResolver dnsResolver) {
        this.dnsResolver = dnsResolver;
    }

    public long getConnTimeToLive() {
        return this.connTimeToLive;
    }

    public void setConnTimeToLive(long connTimeToLive) {
        this.connTimeToLive = connTimeToLive;
    }

    public TimeUnit getConnTimeToLiveTimeUnit() {
        return this.connTimeToLiveTimeUnit;
    }

    public void setConnTimeToLiveTimeUnit(TimeUnit connTimeToLiveTimeUnit) {
        this.connTimeToLiveTimeUnit = connTimeToLiveTimeUnit;
    }

    public SocketConfig getDefaultSocketConfig() {
        return this.defaultSocketConfig;
    }

    public void setDefaultSocketConfig(SocketConfig defaultSocketConfig) {
        this.defaultSocketConfig = defaultSocketConfig;
    }

    public ConnectionConfig getDefaultConnectionConfig() {
        return this.defaultConnectionConfig;
    }

    public void setDefaultConnectionConfig(ConnectionConfig defaultConnectionConfig) {
        this.defaultConnectionConfig = defaultConnectionConfig;
    }
}

