/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.MMath;
import de.mhus.lib.core.MThread;
import de.mhus.lib.core.crypt.AsyncKey;
import de.mhus.lib.core.crypt.MCrypt;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.LinkedList;

public class CipherDecodeAsync
extends InputStream {
    private AsyncKey key;
    private LinkedList<Byte> buffer = new LinkedList();
    private boolean closed = false;

    public CipherDecodeAsync(AsyncKey key) {
        this.key = key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(BigInteger next) throws IOException {
        next = MCrypt.decode(this.key, next);
        byte[] bigEndian = next.toByteArray();
        int size = MMath.unsignetByteToInt(bigEndian[bigEndian.length - 1]);
        LinkedList<Byte> linkedList = this.buffer;
        synchronized (linkedList) {
            for (int i = 1; i <= size; ++i) {
                this.buffer.add(bigEndian[bigEndian.length - i - 1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        LinkedList<Byte> linkedList;
        while (true) {
            linkedList = this.buffer;
            synchronized (linkedList) {
                if (this.buffer.size() != 0) {
                    break;
                }
            }
            if (this.closed) {
                return -1;
            }
            MThread.sleep(500L);
        }
        linkedList = this.buffer;
        synchronized (linkedList) {
            return this.buffer.removeFirst().byteValue();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toBytes() {
        LinkedList<Byte> linkedList = this.buffer;
        synchronized (linkedList) {
            byte[] out = new byte[this.buffer.size()];
            int cnt = 0;
            for (Byte b : this.buffer) {
                out[cnt++] = b;
            }
            return out;
        }
    }
}

