/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.core.console.Console;
import de.mhus.lib.core.io.TextReader;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;

public class ANSIConsole
extends Console {
    protected TextReader reader;
    protected Console.COLOR foreground;
    protected Console.COLOR background;
    protected boolean blink;
    protected boolean bold;
    protected boolean supportColor = true;
    protected int width = DEFAULT_WIDTH;
    protected int height = DEFAULT_HEIGHT;

    public ANSIConsole(boolean supportColor) {
        this();
        this.supportColor = supportColor;
    }

    public ANSIConsole() {
        this.reader = new TextReader(System.in);
        this.loadSettings();
    }

    protected void loadSettings() {
    }

    public ANSIConsole(InputStream in, PrintStream out, boolean flush, String charset) throws UnsupportedEncodingException {
        super(out, flush, charset);
        this.reader = new TextReader(in);
    }

    public ANSIConsole(InputStream in, PrintStream out) {
        super(out);
        this.reader = new TextReader(in);
    }

    @Override
    public String readLine(LinkedList<String> history) {
        return this.reader.readLine();
    }

    @Override
    public boolean isSupportSize() {
        return false;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean isSupportCursor() {
        return true;
    }

    @Override
    public void setCursor(int x, int y) {
        this.print("\u001b[" + y + ";" + x + "H");
    }

    @Override
    public int getCursorX() {
        return -1;
    }

    @Override
    public int getCursorY() {
        return -1;
    }

    @Override
    public boolean isSupportColor() {
        return this.supportColor;
    }

    @Override
    public void setColor(Console.COLOR foreground, Console.COLOR background) {
        this.foreground = foreground;
        this.background = background;
        if (this.supportColor) {
            if (foreground != Console.COLOR.UNKNOWN) {
                this.print("\u001b[3" + this.colorToSequence(foreground) + "m");
            }
            if (background != Console.COLOR.UNKNOWN) {
                this.print("\u001b[4" + this.colorToSequence(background) + "m");
            }
        }
    }

    @Override
    public Console.COLOR getForegroundColor() {
        return this.foreground;
    }

    @Override
    public Console.COLOR getBackgroundColor() {
        return this.background;
    }

    @Override
    public boolean isSupportBlink() {
        return this.supportColor;
    }

    @Override
    public void setBlink(boolean blink) {
        this.blink = blink;
        this.updateAttributes();
    }

    private void updateAttributes() {
        if (this.supportColor) {
            this.print("\u001b[0" + (this.blink ? ";5" : "") + (this.bold ? ";1" : "") + "m");
        }
    }

    @Override
    public boolean isBlink() {
        return this.blink;
    }

    @Override
    public boolean isSupportBold() {
        return this.supportColor;
    }

    @Override
    public void setBold(boolean bold) {
        this.bold = bold;
        this.updateAttributes();
    }

    @Override
    public boolean isBold() {
        return this.bold;
    }

    public String colorToSequence(Console.COLOR col) {
        switch (col) {
            case BLACK: {
                return "0";
            }
            case BLUE: {
                return "4";
            }
            case GREEN: {
                return "2";
            }
            case RED: {
                return "1";
            }
            case WHITE: {
                return "7";
            }
            case YELLOW: {
                return "3";
            }
            case CYAN: {
                return "6";
            }
            case MAGENTA: {
                return "5";
            }
        }
        return "7";
    }

    @Override
    public void cleanup() {
        this.bold = false;
        this.blink = false;
        this.foreground = Console.COLOR.UNKNOWN;
        this.background = Console.COLOR.UNKNOWN;
        this.print("\u001b[0m");
    }

    @Override
    public void resetTerminal() {
        this.print("\u001bc");
    }
}

