/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.AbstractProperties;
import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.IReadProperties;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.core.util.SetCast;
import java.io.BufferedWriter;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MProperties
extends AbstractProperties
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected Properties properties = null;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public MProperties() {
        this(new Properties());
    }

    public MProperties(String ... values) {
        this(new Properties());
        if (values != null) {
            for (int i = 0; i < values.length; i += 2) {
                if (i + 1 >= values.length) continue;
                this.setString(values[i], values[i + 1]);
            }
        }
    }

    public MProperties(Dictionary<?, ?> config) {
        this.properties = new Properties();
        Enumeration<?> enu = config.keys();
        while (enu.hasMoreElements()) {
            Object next = enu.nextElement();
            this.properties.put(String.valueOf(next), config.get(next));
        }
    }

    public MProperties(Map<?, ?> in) {
        this.properties = new Properties();
        for (Map.Entry<?, ?> e : in.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            this.properties.put(String.valueOf(e.getKey()), e.getValue());
        }
    }

    public MProperties(IReadProperties in) {
        this.properties = new Properties();
        for (Map.Entry<String, Object> e : in.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            this.properties.put(String.valueOf(e.getKey()), e.getValue());
        }
    }

    public MProperties(IProperties in) {
        this.properties = new Properties();
        for (Map.Entry<String, Object> e : in.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            this.properties.put(String.valueOf(e.getKey()), e.getValue());
        }
    }

    public MProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public boolean isProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        if (value == null) {
            this.properties.remove(key);
        } else {
            this.properties.put(key, value);
        }
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public Set<String> keys() {
        return new SetCast(this.properties.keySet());
    }

    @Override
    public String toString() {
        return MSystem.toString(this, this.properties);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.properties);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.properties = (Properties)in.readObject();
    }

    public static MProperties explodeToMProperties(String[] properties) {
        return MProperties.explodeToMProperties(properties, '=');
    }

    public static MProperties explodeToMProperties(String[] properties, char separator) {
        MProperties p = new MProperties();
        if (properties != null) {
            int cnt = 0;
            for (String i : properties) {
                if (i == null) continue;
                int idx = i.indexOf(separator);
                if (idx >= 0) {
                    p.setProperty(i.substring(0, idx).trim(), i.substring(idx + 1));
                    continue;
                }
                p.setProperty(String.valueOf(cnt), i);
                ++cnt;
            }
        }
        return p;
    }

    public static Properties explodeToProperties(String[] properties) {
        Properties p = new Properties();
        if (properties != null) {
            for (String i : properties) {
                int idx;
                if (i == null || (idx = i.indexOf(61)) < 0) continue;
                p.setProperty(i.substring(0, idx).trim(), i.substring(idx + 1));
            }
        }
        return p;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.properties.containsValue(value);
    }

    @Override
    public Collection<Object> values() {
        return this.properties.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> wrapper = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            wrapper.put(String.valueOf(entry.getKey()), entry.getValue());
        }
        return wrapper.entrySet();
    }

    public static MProperties load(String fileName) {
        Properties p = new Properties();
        try {
            File f = new File(fileName);
            if (f.exists() && f.isFile()) {
                FileInputStream is = new FileInputStream(f);
                p.load(is);
            }
        }
        catch (Throwable t) {
            MLogUtil.log().d(fileName, t);
        }
        MProperties out = new MProperties(p);
        return out;
    }

    public static MProperties loadOrEmpty(File f) {
        MProperties out = MProperties.load(f);
        if (out == null) {
            out = new MProperties();
        }
        return out;
    }

    public static MProperties load(File f) {
        try {
            FileInputStream fis = new FileInputStream(f);
            MProperties out = MProperties.load(fis);
            fis.close();
            return out;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static MProperties load(InputStream inStream) throws IOException {
        MProperties out = new MProperties();
        out.load0(new LineReader(inStream));
        return out;
    }

    private void load0(LineReader lr) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        while ((limit = lr.readLine()) >= 0) {
            int keyLen;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (c == '=' && !precedingBackslash) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            this.put(key, (Object)value);
        }
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    public static MProperties load(Reader is) {
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (Throwable t) {
            MLogUtil.log().d(t);
        }
        MProperties out = new MProperties(p);
        return out;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    public boolean save(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        boolean ret = this.save(fos);
        fos.close();
        return ret;
    }

    public boolean save(OutputStream out) throws IOException {
        this.store(new BufferedWriter(new OutputStreamWriter(out, "UTF-8")), true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(BufferedWriter bw, boolean escUnicode) throws IOException {
        bw.write("#" + new Date().toString());
        bw.newLine();
        MProperties mProperties = this;
        synchronized (mProperties) {
            for (String key : this.keys()) {
                String val = this.getString(key, "");
                key = this.saveConvert(key, true, escUnicode);
                val = this.saveConvert(val, false, escUnicode);
                bw.write(key + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    private String saveConvert(String value, boolean escapeSpace, boolean escapeUnicode) {
        int len = value.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = value.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(MProperties.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(MProperties.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(MProperties.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(MProperties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    @Override
    public void clear() {
        this.properties.clear();
    }

    private static class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        Reader reader;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

