/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MThread;
import de.mhus.lib.core.cfg.UpdaterCfg;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.logging.LevelMapper;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.TrailLevelMapper;
import de.mhus.lib.core.system.ApiInitialize;
import de.mhus.lib.core.system.DefaultMApi;
import de.mhus.lib.core.system.DummyClass;
import de.mhus.lib.core.system.IApi;
import de.mhus.lib.core.system.IApiFactory;
import de.mhus.lib.errors.TimeoutRuntimeException;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;

public class MApi {
    private static IApi api;
    protected static Boolean trace;
    private static IConfig emptyConfig;
    private static UpdaterCfg configUpdater;
    public static PrintStream out;

    private MApi() {
    }

    public static synchronized IApi get() {
        if (api == null) {
            block8: {
                try {
                    IApi obj = null;
                    String path = "de.mhus.lib.mutable.MApiFactory";
                    if (System.getProperty("mhu.lib.api.factory") != null) {
                        path = System.getProperty("mhus.api.factory");
                    }
                    MApi.dirtyLog("--- MApiFactory", path);
                    IApiFactory factory = (IApiFactory)Class.forName(path).newInstance();
                    if (factory != null) {
                        obj = factory.createApi();
                    }
                    api = obj;
                }
                catch (Throwable t) {
                    if (!MApi.isDirtyTrace()) break block8;
                    t.printStackTrace();
                }
            }
            if (api == null) {
                api = new DefaultMApi();
            }
            if (MApi.isDirtyTrace()) {
                System.out.println("--- MApi: " + api.getClass().getCanonicalName());
            }
            if (api instanceof ApiInitialize) {
                ((ApiInitialize)((Object)api)).doInitialize(DummyClass.class.getClassLoader());
            }
        }
        return api;
    }

    public static boolean isDirtyTrace() {
        if (trace == null) {
            trace = "true".equals(System.getProperty("mhu.lib.api.trace"));
        }
        return trace;
    }

    public static void setDirtyTrace(boolean dt) {
        trace = dt;
    }

    public static boolean isTrace(String name) {
        MApi.dirtyLog("--- Ask for trace", name);
        return MApi.get().isTrace(name);
    }

    public static void doStartTrailLog() {
        LevelMapper mapper = MApi.get().getLogFactory().getLevelMapper();
        if (mapper != null && mapper instanceof TrailLevelMapper) {
            ((TrailLevelMapper)mapper).doConfigureTrail("MAP");
        }
    }

    public static void doStopTrailLog() {
        LevelMapper mapper = MApi.get().getLogFactory().getLevelMapper();
        if (mapper != null && mapper instanceof TrailLevelMapper) {
            ((TrailLevelMapper)mapper).doResetTrail();
        }
    }

    public static void updateLoggers() {
        Log.getLog(MApi.class);
        MApi.get().updateLog();
    }

    public static IConfig getCfg(Object owner, IConfig def) {
        return MApi.get().getCfgManager().getCfg(owner, def);
    }

    public static IConfig getCfg(Object owner) {
        if (emptyConfig == null) {
            emptyConfig = new HashConfig();
        }
        return MApi.get().getCfgManager().getCfg(owner, emptyConfig);
    }

    public static synchronized UpdaterCfg getCfgUpdater() {
        if (configUpdater == null) {
            configUpdater = new UpdaterCfg();
        }
        return configUpdater;
    }

    public static File getFile(String path) {
        return MApi.get().getFile(path);
    }

    public static <T> T lookup(Class<T> class1) {
        return MApi.get().getBaseControl().base().lookup(class1);
    }

    public static <T, D extends T> T lookup(Class<T> class1, Class<D> def) {
        return MApi.get().getBaseControl().base().lookup(class1, def);
    }

    public static <T> T waitFor(Class<? extends T> ifc, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                T api = MApi.lookup(ifc);
                if (api != null) {
                    return api;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (System.currentTimeMillis() - start > timeout) {
                throw new TimeoutRuntimeException(new Object[]{"timeout getting API", ifc});
            }
            MThread.sleep(500L);
        }
    }

    public static void dirtyLog(Object ... string) {
        if (string == null || !MApi.isDirtyTrace()) {
            return;
        }
        out.println(Arrays.toString(string));
        for (Object s : string) {
            if (!(s instanceof Throwable)) continue;
            ((Throwable)s).printStackTrace(out);
        }
    }

    static {
        emptyConfig = null;
        out = System.out;
    }
}

