/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.logging.level;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MMath;
import de.mhus.lib.core.logging.LevelMapper;
import de.mhus.lib.core.logging.Log;

public class ThreadMapperConfig
implements LevelMapper {
    public static final String MAP_LABEL = "MAP";
    private static long nextId = 0L;
    private Log.LEVEL debug = Log.LEVEL.INFO;
    private Log.LEVEL error = Log.LEVEL.ERROR;
    private Log.LEVEL fatal = Log.LEVEL.FATAL;
    private Log.LEVEL info = Log.LEVEL.INFO;
    private Log.LEVEL trace = Log.LEVEL.TRACE;
    private Log.LEVEL warn = Log.LEVEL.WARN;
    private boolean local = false;
    private long timeout = 0L;
    private long timetout = 0L;
    private String id = MMath.toBasis36WithIdent((long)(Math.random() * 36.0 * 36.0 * 36.0 * 36.0), ++nextId, 8);

    public boolean isTimedOut() {
        if (this.timetout <= 0L) {
            return false;
        }
        return System.currentTimeMillis() >= this.timetout;
    }

    @Override
    public Log.LEVEL map(Log log, Log.LEVEL level, Object ... msg) {
        switch (level) {
            case DEBUG: {
                return this.debug;
            }
            case ERROR: {
                return this.error;
            }
            case FATAL: {
                return this.fatal;
            }
            case INFO: {
                return this.info;
            }
            case TRACE: {
                return this.trace;
            }
            case WARN: {
                return this.warn;
            }
        }
        return level;
    }

    public void doConfigure(String config) {
        if (config == null) {
            return;
        }
        String[] parts = config.toUpperCase().split(",");
        if (parts.length > 1) {
            this.trace = this.toLevel(parts[1]);
        }
        if (parts.length > 2) {
            this.debug = this.toLevel(parts[2]);
        }
        if (parts.length > 3) {
            this.info = this.toLevel(parts[3]);
        }
        if (parts.length > 4) {
            this.warn = this.toLevel(parts[4]);
        }
        if (parts.length > 5) {
            this.error = this.toLevel(parts[5]);
        }
        if (parts.length > 6) {
            this.fatal = this.toLevel(parts[6]);
        }
        if (parts.length > 7) {
            this.local = parts[7].equals("L");
        }
        if (parts.length > 8) {
            this.setTimeout(MCast.tolong(parts[8], 0L));
        }
        if (parts.length > 9) {
            this.id = parts[9];
        }
    }

    private Log.LEVEL toLevel(String in) {
        switch (in) {
            case "T": {
                return Log.LEVEL.TRACE;
            }
            case "D": {
                return Log.LEVEL.DEBUG;
            }
            case "I": {
                return Log.LEVEL.INFO;
            }
            case "W": {
                return Log.LEVEL.WARN;
            }
            case "E": {
                return Log.LEVEL.ERROR;
            }
            case "F": {
                return Log.LEVEL.FATAL;
            }
        }
        return Log.LEVEL.TRACE;
    }

    public String doSerialize() {
        return "MAP," + this.trace.name().substring(0, 1) + "," + this.debug.name().substring(0, 1) + "," + this.info.name().substring(0, 1) + "," + this.warn.name().substring(0, 1) + "," + this.error.name().substring(0, 1) + "," + this.fatal.name().substring(0, 1) + "," + (this.local ? "L" : "G") + "," + this.timeout + "," + this.id;
    }

    public String toString() {
        return this.doSerialize();
    }

    public boolean isLocal() {
        return this.local;
    }

    public void setLocal(boolean local) {
        this.local = local;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timetout = timeout <= 0L ? 0L : System.currentTimeMillis() + timeout;
        this.timeout = timeout;
    }

    @Override
    public void prepareMessage(Log log, StringBuffer msg) {
        msg.append('{').append(this.id).append('}');
        msg.append('(').append(Thread.currentThread().getId()).append(')');
    }

    public String getTrailId() {
        return this.id;
    }
}

