/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.logging;

import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.logging.LogEngine;
import de.mhus.lib.core.logging.LogFactory;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaLoggerFactory
extends LogFactory {
    @Override
    public void init(ResourceNode config) throws Exception {
    }

    @Override
    public LogEngine createInstance(String name) {
        return new JLLog(Logger.getLogger(name), name);
    }

    private class JLLog
    extends LogEngine {
        private Logger logger;

        private JLLog(Logger logger, String name) {
            super(name);
            this.logger = logger;
        }

        @Override
        public void trace(Object message) {
            this.getLogger().log(Level.ALL, String.valueOf(message));
        }

        @Override
        public void trace(Object message, Throwable t) {
            this.getLogger().log(Level.ALL, String.valueOf(message), t);
        }

        @Override
        public void debug(Object message) {
            this.getLogger().log(Level.FINE, String.valueOf(message));
        }

        @Override
        public void debug(Object message, Throwable t) {
            this.getLogger().log(Level.FINE, String.valueOf(message), t);
        }

        @Override
        public void info(Object message) {
            this.getLogger().log(Level.INFO, String.valueOf(message));
        }

        @Override
        public void info(Object message, Throwable t) {
            if (t == null) {
                this.getLogger().info(String.valueOf(message));
            } else {
                this.getLogger().log(Level.INFO, String.valueOf(message), t);
            }
        }

        @Override
        public void warn(Object message) {
            this.getLogger().log(Level.WARNING, String.valueOf(message));
        }

        @Override
        public void warn(Object message, Throwable t) {
            this.getLogger().log(Level.WARNING, String.valueOf(message), t);
        }

        @Override
        public void error(Object message) {
            this.getLogger().log(Level.SEVERE, String.valueOf(message));
        }

        @Override
        public void error(Object message, Throwable t) {
            this.getLogger().log(Level.SEVERE, String.valueOf(message), t);
        }

        @Override
        public void fatal(Object message) {
            this.getLogger().log(Level.SEVERE, String.valueOf(message));
        }

        @Override
        public void fatal(Object message, Throwable t) {
            this.getLogger().log(Level.SEVERE, String.valueOf(message), t);
        }

        public Logger getLogger() {
            if (this.logger == null) {
                this.logger = Logger.getLogger(this.getName());
            }
            return this.logger;
        }

        @Override
        public boolean isDebugEnabled() {
            return this.getLogger().isLoggable(Level.FINE);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.getLogger().isLoggable(Level.SEVERE);
        }

        @Override
        public boolean isFatalEnabled() {
            return this.getLogger().isLoggable(Level.SEVERE);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.getLogger().isLoggable(Level.INFO);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.getLogger().isLoggable(Level.FINEST);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.getLogger().isLoggable(Level.WARNING);
        }

        @Override
        public void doInitialize(LogFactory logFactory) {
        }

        @Override
        public void close() {
        }
    }
}

