/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.form;

import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.logging.MLogUtil;
import de.mhus.lib.errors.MException;
import de.mhus.lib.form.MForm;
import de.mhus.lib.form.UiWizard;

public abstract class UiComponent {
    public static final String FULL_SIZE = "fullSize";
    public static final String FULL_SIZE_DEFAULT = "fullSizeDefault";
    private static final String WIZARD = null;
    private MForm form;
    private IConfig config;

    public void doInit(MForm form, IConfig config) {
        this.form = form;
        this.config = config;
    }

    public MForm getForm() {
        return this.form;
    }

    public IConfig getConfig() {
        return this.config;
    }

    public abstract void doRevert() throws MException;

    public abstract void doUpdateValue() throws MException;

    public abstract void doUpdateMetadata() throws MException;

    public abstract void setVisible(boolean var1) throws MException;

    public abstract boolean isVisible() throws MException;

    public abstract void setEnabled(boolean var1) throws MException;

    public abstract void setEditable(boolean var1) throws MException;

    public abstract boolean isEnabled() throws MException;

    public boolean isFullSize() {
        return this.config.getBoolean(FULL_SIZE, this.config.getBoolean(FULL_SIZE_DEFAULT, false));
    }

    public UiWizard getWizard() {
        Object obj = this.config.getProperty(WIZARD);
        if (obj == null) {
            return null;
        }
        if (obj instanceof UiWizard) {
            return (UiWizard)obj;
        }
        try {
            if (obj instanceof String) {
                return this.getForm().getAdapterProvider().createWizard((String)obj);
            }
        }
        catch (Exception e) {
            MLogUtil.log().d(e);
        }
        return null;
    }

    public String getName() {
        return this.config.getString("name", "");
    }

    public abstract void setError(String var1);

    public abstract void clearError();

    public String getConfigString(String name, String def) {
        IConfig c = this.getConfig();
        if (c == null) {
            return def;
        }
        return c.getString(name, def);
    }
}

