/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.basics.Versioned;
import de.mhus.lib.core.util.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionRange {
    Version high;
    Version low;
    char start = (char)91;
    char end = (char)93;
    public static final String VERSION_STRING = "(\\d+)(\\.(\\d+)(\\.(\\d+)(\\.([-_\\da-zA-Z]+))?)?)?";
    static Pattern RANGE = Pattern.compile("(\\(|\\[)\\s*((\\d+)(\\.(\\d+)(\\.(\\d+)(\\.([-_\\da-zA-Z]+))?)?)?)\\s*,\\s*((\\d+)(\\.(\\d+)(\\.(\\d+)(\\.([-_\\da-zA-Z]+))?)?)?)\\s*(\\)|\\])");

    public VersionRange(String string) {
        Matcher m;
        string = string.trim();
        if (string.indexOf(44) > 0) {
            if (!string.startsWith("[") && !string.startsWith("(")) {
                string = "[" + string;
            }
            if (!string.endsWith("]") && !string.endsWith(")")) {
                string = string + ")";
            }
        }
        if ((m = RANGE.matcher(string)).matches()) {
            this.start = m.group(1).charAt(0);
            String v1 = m.group(2);
            String v2 = m.group(10);
            this.low = new Version(v1);
            this.high = new Version(v2);
            this.end = m.group(18).charAt(0);
            if (this.low.compareTo(this.high) > 0) {
                throw new IllegalArgumentException("Low Range is higher than High Range: " + this.low + "-" + this.high);
            }
        } else {
            this.high = this.low = new Version(string);
        }
    }

    public boolean isRange() {
        return this.high != this.low;
    }

    public boolean includeLow() {
        return this.start == '[';
    }

    public boolean includeHigh() {
        return this.end == ']';
    }

    public String toString() {
        if (this.high == this.low) {
            return this.high.toString();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.start);
        sb.append(this.low);
        sb.append(',');
        sb.append(this.high);
        sb.append(this.end);
        return sb.toString();
    }

    public Version getLow() {
        return this.low;
    }

    public Version getHigh() {
        return this.high;
    }

    public boolean includes(Versioned v) {
        return this.includes(new Version(v.getVersionString()));
    }

    public boolean includes(Version v) {
        if (!this.isRange()) {
            return this.low.compareTo(v) <= 0;
        }
        if (this.includeLow() ? v.compareTo(this.low) < 0 : v.compareTo(this.low) <= 0) {
            return false;
        }
        return !(this.includeHigh() ? v.compareTo(this.high) > 0 : v.compareTo(this.high) >= 0);
    }
}

