/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.MThreadDaemon;

public final class TimeoutController {
    private TimeoutController() {
    }

    public static void execute(Thread task, long timeout) throws TimeoutException {
        task.start();
        try {
            task.join(timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (task.isAlive()) {
            task.interrupt();
            throw new TimeoutException();
        }
    }

    public static void execute(Runnable task, long timeout) throws TimeoutException {
        MThreadDaemon t = new MThreadDaemon(task, "Timeout guard");
        TimeoutController.execute(t, timeout);
    }

    public static class TimeoutException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

