/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MJson;
import de.mhus.lib.core.pojo.MPojo;
import de.mhus.lib.core.util.Table;
import de.mhus.lib.errors.NotFoundRuntimeException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

public class TableRow
implements Serializable {
    private static final long serialVersionUID = 1L;
    LinkedList<Object> data = new LinkedList();
    private Table table;

    public List<Object> getData() {
        return this.data;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.data.size());
        for (Object e : this.data) {
            if (e == null || e instanceof Serializable) {
                out.writeInt(0);
                out.writeObject(e);
                continue;
            }
            out.writeInt(1);
            ObjectNode to = MJson.createObjectNode();
            MPojo.pojoToJson(e, to);
            out.writeUTF(e.getClass().getCanonicalName());
            out.writeUTF(MJson.toString((JsonNode)to));
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        this.data = new LinkedList();
        for (int i = 0; i < size; ++i) {
            Object obj;
            int code = in.readInt();
            if (code == 0) {
                Object d = in.readObject();
                this.data.add(d);
                continue;
            }
            if (code != 1) continue;
            String clazzName = in.readUTF();
            try {
                obj = MApi.get().base().lookup(MActivator.class).createObject(clazzName);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            String jsonString = in.readUTF();
            JsonNode json = MJson.load(jsonString);
            MPojo.jsonToPojo(json, obj);
            this.data.add(obj);
        }
    }

    public void appendData(Object ... d) {
        for (Object o : d) {
            this.data.add(o);
        }
    }

    public void setData(Object ... d) {
        this.data.clear();
        for (Object o : d) {
            this.data.add(o);
        }
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.data.size()) {
            throw new NotFoundRuntimeException(new Object[]{"column index not found", index});
        }
        return this.data.get(index);
    }

    public Object get(String name) {
        int index = this.table.getColumnIndex(name);
        if (index == -1) {
            throw new NotFoundRuntimeException(new Object[]{"column not found", name});
        }
        return this.get(index);
    }

    public <T> T get(String name, T def) {
        int index = this.table.getColumnIndex(name);
        if (index == -1) {
            return def;
        }
        Object val = this.get(index);
        if (val == null) {
            return def;
        }
        return (T)val;
    }
}

