/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MCast;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;

public class MUri {
    public static String decode(String _in) {
        if (_in == null) {
            return "";
        }
        try {
            return URLDecoder.decode(_in, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            StringBuffer sb = new StringBuffer();
            int mode = 0;
            int buffer = 0;
            for (int i = 0; i < _in.length(); ++i) {
                char c = _in.charAt(i);
                if (mode == 0) {
                    if (c == '%') {
                        mode = 1;
                        buffer = 0;
                        continue;
                    }
                    if (c == '+') {
                        sb.append(' ');
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (mode == 1) {
                    if (c >= '0' && c <= '9') {
                        buffer = c - 48;
                    } else if (c >= 'A' && c <= 'F') {
                        buffer = c + 10 - 65;
                    } else if (c >= 'a' && c <= 'f') {
                        buffer = c + 10 - 97;
                    }
                    mode = 2;
                    continue;
                }
                if (mode != 2) continue;
                buffer *= 16;
                if (c >= '0' && c <= '9') {
                    buffer += c - 48;
                } else if (c >= 'A' && c <= 'F') {
                    buffer += c + 10 - 65;
                } else if (c >= 'a' && c <= 'f') {
                    buffer += c + 10 - 97;
                }
                sb.append((char)buffer);
                mode = 0;
            }
            return sb.toString();
        }
    }

    public static String encode(String _in) {
        if (_in == null) {
            return "";
        }
        try {
            return URLEncoder.encode(_in, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return MUri.encodeNoUTF8(_in);
        }
    }

    public static String encodeNoUTF8(String _in) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < _in.length(); ++i) {
            char c = _in.charAt(i);
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == ',' || c == '.')) {
                MUri.encodeNoUTF8(sb, c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String encode(char c) {
        StringBuffer sb = new StringBuffer();
        MUri.encodeNoUTF8(sb, c);
        return sb.toString();
    }

    public static void encodeNoUTF8(StringBuffer sb, char c) {
        if (c == ' ') {
            sb.append('+');
            return;
        }
        sb.append('%');
        int buffer = 0;
        char cc = c;
        buffer = cc / 16;
        if (buffer < 10) {
            sb.append((char)(48 + buffer));
        } else {
            sb.append((char)(55 + buffer));
        }
        buffer = cc % 16;
        if (buffer < 10) {
            sb.append((char)(48 + buffer));
        } else {
            sb.append((char)(55 + buffer));
        }
    }

    public static String implodeArray(String ... in) {
        if (in == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String i : in) {
            if (!first) {
                sb.append('&');
            }
            sb.append(MUri.encode(i));
            first = false;
        }
        return sb.toString();
    }

    public static String implodeKeyValues(String ... in) {
        if (in == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        boolean key = true;
        for (String i : in) {
            if (!first && key) {
                sb.append('&');
            }
            sb.append(MUri.encode(i));
            first = false;
            if (key) {
                sb.append('=');
                key = false;
                continue;
            }
            key = true;
        }
        return sb.toString();
    }

    public static String[] explodeArray(String in) {
        if (in == null || in.length() == 0) {
            return new String[0];
        }
        String[] out = in.split("&");
        for (int i = 0; i < out.length; ++i) {
            out[i] = MUri.decode(out[i]);
        }
        return out;
    }

    public static Map<String, String> explode(String _in) {
        if (_in == null) {
            return new TreeMap<String, String>();
        }
        TreeMap<String, String> out = new TreeMap<String, String>();
        String[] obj = _in.split("&");
        for (int i = 0; i < obj.length; ++i) {
            String[] kv = obj[i].split("=");
            if (kv.length == 2) {
                if (kv[1] == null) {
                    kv[1] = "";
                }
                out.put(MUri.decode(kv[0]), MUri.decode(kv[1]));
                continue;
            }
            if (kv.length != 1) continue;
            out.put(MUri.decode(kv[0]), "");
        }
        return out;
    }

    public static String implode(Map<String, String> _in) {
        if (_in == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String key : _in.keySet()) {
            String value = _in.get(key);
            if (value == null) continue;
            if (!first) {
                sb.append('&');
            }
            sb.append(MUri.encode(key));
            sb.append('=');
            sb.append(MUri.encode(value));
            first = false;
        }
        return sb.toString();
    }

    public static String implode(IProperties _in) {
        if (_in == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (String key : _in.keys()) {
            String value = _in.getString(key, null);
            if (value == null) continue;
            if (!first) {
                sb.append('&');
            }
            sb.append(MUri.encode(key));
            sb.append('=');
            sb.append(MUri.encode(value));
            first = false;
        }
        return sb.toString();
    }

    public static void setParameterValue(String url, String name, String value) {
        name = MUri.encode(name) + "=";
        value = MUri.encode(value);
        int pos = url.indexOf("&" + name);
        if (pos < 0) {
            pos = url.indexOf("?" + name);
        }
        if (pos < 0) {
            url = url.contains("?") ? url + "&" : url + "?";
            url = url + name + value;
        } else {
            int pos2 = url.indexOf("&", pos + 1);
            url = pos2 < 0 ? url.substring(0, pos + 1 + name.length()) + value : url.substring(0, pos + 1 + name.length()) + value + url.substring(pos2);
        }
    }

    public static class Query
    extends TreeMap<String, String> {
        private static final long serialVersionUID = -1L;

        @Override
        public void put(String _key, int _value) {
            this.put(_key, MCast.toString(_value));
        }

        public int getInt(String _key, int _def) {
            String v = (String)this.get(_key);
            if (v == null) {
                return _def;
            }
            return MCast.toint(v, 0);
        }

        public int getInt(String _key) {
            return this.getInt(_key, -1);
        }

        @Override
        public String toString() {
            return MUri.implode(this);
        }
    }
}

