/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.AbstractProperties;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.parser.StringCompiler;
import de.mhus.lib.core.util.MNlsFactory;
import de.mhus.lib.core.util.MNlsProvider;
import de.mhus.lib.core.util.SetCast;
import de.mhus.lib.errors.MException;
import de.mhus.lib.errors.NotSupportedException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MNls
extends AbstractProperties {
    protected Properties properties = null;
    protected String prefix = "";

    public MNls() {
        this(new Properties(), "");
    }

    public MNls(Properties properties, String prefix) {
        this.properties = properties;
        this.prefix = prefix == null || "".equals(prefix) ? "" : prefix + ".";
    }

    public String find(String in, String ... strings) {
        if (strings == null || strings.length == 0) {
            return this.find(in, (Map<String, Object>)null);
        }
        HashMap<String, Object> attr = new HashMap<String, Object>();
        for (int i = 0; i < strings.length; ++i) {
            attr.put(String.valueOf(i), strings[i]);
        }
        return this.find(in, attr);
    }

    public String find(String in) {
        return this.find(in, (Map<String, Object>)null);
    }

    public String find(String in, Map<String, Object> attributes) {
        return MNls.find(this, in, attributes);
    }

    public static String find(MNlsProvider provider, String in) {
        return MNls.find(provider == null ? null : provider.getNls(), in, null);
    }

    public static String find(MNls nls, String in) {
        return MNls.find(nls, in, null);
    }

    public static String find(MNls nls, String in, Map<String, Object> attributes) {
        String def = null;
        if (in == null) {
            return "";
        }
        int pos = in.indexOf("=");
        if (pos == 0) {
            return in.substring(1);
        }
        if (pos > 0) {
            def = in.substring(pos + 1);
            in = in.substring(0, pos);
        }
        if (def == null) {
            def = in;
        }
        if (nls == null) {
            return def;
        }
        try {
            String ret = nls.getString(in, def);
            if (ret == null) {
                return def;
            }
            if (attributes != null && ret.indexOf(36) >= 0) {
                ret = StringCompiler.compile(ret).execute(attributes);
            }
            return ret;
        }
        catch (MException mException) {
            return in;
        }
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(this.prefix + name);
    }

    @Override
    public boolean isProperty(String name) {
        return this.properties.containsKey(this.prefix + name);
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(this.prefix + key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(this.prefix + key, value);
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public Set<String> keys() {
        return new SetCast(this.properties.keySet());
    }

    @Override
    public String toString() {
        return MSystem.toString(this, this.properties);
    }

    public MNls createSubstitute(String prefix) {
        if (prefix == null) {
            return this;
        }
        return new MNls(this.properties, this.prefix + prefix);
    }

    public static MNls lookup(Object owner) {
        MNlsFactory factory = MNlsFactory.lookup(owner);
        if (factory != null) {
            return factory.load(owner.getClass());
        }
        return null;
    }

    public static MNls lookup(Object owner, Locale locale) {
        MNlsFactory factory = MNlsFactory.lookup(owner);
        if (factory != null) {
            return factory.load(owner.getClass(), locale);
        }
        return null;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public Collection<Object> values() {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        throw new NotSupportedException(new Object[0]);
    }

    @Override
    public void clear() {
        this.properties.clear();
    }
}

