/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.security;

import de.mhus.lib.core.IReadProperties;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.security.Account;
import de.mhus.lib.core.security.LoginCallbackHandler;
import de.mhus.lib.errors.NotSupportedException;
import java.security.Principal;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class JaasAccount
implements Account {
    private String realm;
    private Subject subject;
    private String userName;
    private HashSet<String> groups;
    private MProperties attr;

    public JaasAccount(String realm, Subject subject) {
        this.realm = realm;
        this.subject = subject;
        this.groups = new HashSet();
        this.attr = new MProperties();
        int cnt = 0;
        for (Principal principal : subject.getPrincipals()) {
            switch (principal.getClass().getSimpleName()) {
                case "UserPrincipal": {
                    this.userName = principal.getName();
                    break;
                }
                case "RolePrincipal": {
                    this.groups.add(principal.getName());
                }
            }
            this.attr.put(principal.getClass().getSimpleName() + "." + cnt, (Object)principal.getName());
            ++cnt;
        }
    }

    @Override
    public boolean hasGroup(String role) {
        return this.groups.contains(role);
    }

    @Override
    public String getName() {
        return this.userName;
    }

    @Override
    public boolean isValid() {
        return this.subject != null;
    }

    @Override
    public boolean validatePassword(String password) {
        try {
            LoginCallbackHandler handler = new LoginCallbackHandler(this.userName, password);
            LoginContext lc = new LoginContext(this.realm, handler);
            lc.login();
            return true;
        }
        catch (LoginException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isSyntetic() {
        return false;
    }

    @Override
    public String getDisplayName() {
        return this.userName;
    }

    @Override
    public IReadProperties getAttributes() {
        return this.attr;
    }

    @Override
    public void putAttributes(IReadProperties properties) throws NotSupportedException {
        throw new NotSupportedException(new Object[0]);
    }
}

