/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.schedule;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.base.service.TimerIfc;
import de.mhus.lib.core.schedule.IntervalWithStartTimeJob;
import de.mhus.lib.core.schedule.MutableSchedulerJob;
import de.mhus.lib.core.schedule.ObserverTimerTaskAdapter;
import de.mhus.lib.core.schedule.OnceJob;
import de.mhus.lib.core.schedule.Scheduler;
import de.mhus.lib.core.schedule.SchedulerJob;
import java.util.Date;
import java.util.Observer;
import java.util.TimerTask;

public class SchedulerTimer
extends Scheduler
implements TimerIfc {
    public SchedulerTimer() {
    }

    public SchedulerTimer(String name) {
        super(name);
    }

    @Override
    public void schedule(TimerTask task, long delay) {
        this.schedule(new OnceJob(System.currentTimeMillis() + delay, (Observer)new ObserverTimerTaskAdapter(task)));
    }

    @Override
    public void schedule(TimerTask task, Date time) {
        this.schedule(new OnceJob(time, (Observer)new ObserverTimerTaskAdapter(task)));
    }

    @Override
    public void schedule(TimerTask task, long delay, long period) {
        this.schedule(new IntervalWithStartTimeJob(System.currentTimeMillis() + delay, period, new ObserverTimerTaskAdapter(task)));
    }

    @Override
    public void schedule(TimerTask task, Date firstTime, long period) {
        this.schedule(new IntervalWithStartTimeJob(firstTime.getTime(), period, new ObserverTimerTaskAdapter(task)));
    }

    @Override
    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        this.schedule(new IntervalWithStartTimeJob(System.currentTimeMillis() + delay, period, new ObserverTimerTaskAdapter(task)));
    }

    @Override
    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        this.schedule(new IntervalWithStartTimeJob(firstTime.getTime(), period, new ObserverTimerTaskAdapter(task)));
    }

    @Override
    public void schedule(SchedulerJob job) {
        super.schedule(job);
        this.configureDefault(job);
    }

    public void configureDefault(SchedulerJob job) {
        MProperties properties = this.loadConfiguration();
        String n = job.getName();
        for (String key : properties.keys()) {
            String v;
            if (!MString.compareFsLikePattern(n, key) || (v = properties.getString(key, null)) == null) continue;
            this.log().d("confiure by config file", n, key, v);
            if (v.equals("disabled")) {
                job.doReschedule(this, -1L);
            } else {
                ((MutableSchedulerJob)((Object)job)).doReconfigure(v);
                job.doReschedule(this, 0L);
            }
            return;
        }
    }

    private MProperties loadConfiguration() {
        MProperties properties = MProperties.load(MApi.get().getSystemProperty("timer.config.file", "mhus_timer.properties"));
        return properties;
    }

    @Override
    public void cancel() {
        this.stop();
    }
}

