/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.schedule;

import de.mhus.lib.core.schedule.SchedulerJob;
import de.mhus.lib.core.schedule.SchedulerQueue;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class QueueList
implements SchedulerQueue {
    private LinkedList<SchedulerJob> list = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchedulerJob> removeJobs(long toTime) {
        LinkedList<SchedulerJob> out = null;
        QueueList queueList = this;
        synchronized (queueList) {
            SchedulerJob first;
            while (this.list.size() != 0 && (first = this.list.getFirst()).getScheduledTime() <= toTime) {
                if (out == null) {
                    out = new LinkedList<SchedulerJob>();
                }
                out.add(first);
                this.list.removeFirst();
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSchedule(SchedulerJob schedulerJob) {
        long time = schedulerJob.getScheduledTime();
        if (time <= 0L) {
            return;
        }
        QueueList queueList = this;
        synchronized (queueList) {
            Iterator iter = this.list.iterator();
            int pos = 0;
            while (iter.hasNext()) {
                SchedulerJob item = (SchedulerJob)iter.next();
                if (item.getScheduledTime() >= time) {
                    this.list.add(pos, schedulerJob);
                    return;
                }
                ++pos;
            }
            this.list.add(schedulerJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJob(SchedulerJob job) {
        QueueList queueList = this;
        synchronized (queueList) {
            Iterator iter = this.list.iterator();
            while (iter.hasNext()) {
                SchedulerJob item = (SchedulerJob)iter.next();
                if (!job.equals(item)) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        QueueList queueList = this;
        synchronized (queueList) {
            return this.list.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SchedulerJob> getJobs() {
        QueueList queueList = this;
        synchronized (queueList) {
            return new LinkedList<SchedulerJob>(this.list);
        }
    }
}

