/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.schedule;

import de.mhus.lib.core.MDate;
import de.mhus.lib.core.schedule.MutableSchedulerJob;
import de.mhus.lib.core.schedule.Scheduler;
import de.mhus.lib.core.schedule.SchedulerJob;
import java.util.Date;
import java.util.Observer;

public class OnceJob
extends SchedulerJob
implements MutableSchedulerJob {
    private long time;

    public OnceJob(Date time, Observer task) {
        this(time.getTime(), task);
    }

    public OnceJob(long time, Observer task) {
        super(task);
        this.time = time;
    }

    @Override
    public void doCaclulateNextExecution() {
        if (this.isDone()) {
            this.setNextExecutionTime(-2L);
        } else {
            this.setNextExecutionTime(this.time);
        }
    }

    @Override
    public void setDone(boolean done) {
        super.setDone(done);
        if (done) {
            this.cancel();
        }
    }

    @Override
    public String toString() {
        return OnceJob.class.getSimpleName() + "," + this.isDone() + "," + MDate.toIsoDateTime(this.time);
    }

    @Override
    public void doReschedule(Scheduler queue, long time) {
        super.doReschedule(queue, time);
    }

    @Override
    public boolean doReconfigure(String config) {
        return false;
    }

    @Override
    public void setScheduledTime(long scheduledTime) {
        super.setScheduledTime(scheduledTime);
    }
}

