/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.schedule;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.base.service.HolidayProviderIfc;
import de.mhus.lib.core.schedule.MutableSchedulerJob;
import de.mhus.lib.core.schedule.Scheduler;
import de.mhus.lib.core.schedule.SchedulerJob;
import java.util.Calendar;
import java.util.Observer;

public class CronJob
extends SchedulerJob
implements MutableSchedulerJob {
    private Definition definition;
    private boolean restrictive = true;

    public CronJob(String name, Definition definition, boolean restrictive, Observer task) {
        super(name, task);
        this.setRestrictive(restrictive);
        if (definition == null) {
            throw new NullPointerException("definition is null");
        }
        this.definition = definition;
    }

    public CronJob(String minute, String hour, String dayOfMonth, String month, String dayOfWeek, Observer task) {
        super(task);
        if (minute == null) {
            minute = "*";
        }
        if (hour == null) {
            hour = "*";
        }
        if (dayOfMonth == null) {
            dayOfMonth = "*";
        }
        if (month == null) {
            month = "*";
        }
        if (dayOfWeek == null) {
            dayOfWeek = "*";
        }
        this.definition = new Definition(minute + " " + hour + " " + dayOfMonth + " " + month + " " + dayOfWeek);
    }

    public CronJob(String definition, Observer task) {
        super(task);
        if (definition == null) {
            throw new NullPointerException("definition is null");
        }
        this.definition = new Definition(definition);
    }

    public CronJob(String name, String definition, Observer task) {
        super(name, task);
        if (definition == null) {
            throw new NullPointerException("definition is null");
        }
        this.definition = new Definition(definition);
    }

    public CronJob(String name, String definition, boolean restrictive, Observer task) {
        super(name, task);
        this.setRestrictive(restrictive);
        if (definition == null) {
            throw new NullPointerException("definition is null");
        }
        this.definition = new Definition(definition);
    }

    @Override
    public void doCaclulateNextExecution() {
        this.setNextExecutionTime(this.definition.calculateNext(System.currentTimeMillis()));
    }

    @Override
    protected boolean isExecutionTimeReached() {
        if (this.restrictive && this.getNextExecutionTime() > 0L && System.currentTimeMillis() + 60000L <= this.getNextExecutionTime()) {
            log.d("cron restrictive over time, reschedule job", this.getName(), this.getTask());
            this.doCaclulateNextExecution();
        }
        return super.isExecutionTimeReached();
    }

    public boolean isRestrictive() {
        return this.restrictive;
    }

    public void setRestrictive(boolean restrictive) {
        this.restrictive = restrictive;
    }

    @Override
    public String toString() {
        return CronJob.class.getSimpleName() + "," + this.definition;
    }

    @Override
    public void doReschedule(Scheduler queue, long time) {
        super.doReschedule(queue, time);
    }

    @Override
    public void setDone(boolean done) {
        super.setDone(done);
    }

    @Override
    public boolean doReconfigure(String config) {
        this.definition = new Definition(config);
        return true;
    }

    @Override
    public void setScheduledTime(long scheduledTime) {
        super.setScheduledTime(scheduledTime);
    }

    public static class Definition {
        private int[] allowedMinutes;
        private int[] allowedHours;
        private int[] allowedDaysMonth;
        private int[] allowedMonthes;
        private int[] allowedDaysWeek;
        private String definition;
        private boolean disabled = false;
        private boolean onlyWorkingDays = false;

        public Definition() {
        }

        public Definition(String definition) {
            this.definition = definition.trim();
            String[] parts = this.definition.split(" ");
            if (parts.length == 0) {
                parts = new String[]{"disabled"};
            }
            if (parts.length == 1) {
                if (parts[0].equals("disabled")) {
                    parts = new String[]{"*", "*", "*", "*", "*", "disabled"};
                } else {
                    int i = MCast.toint(parts[0], 0);
                    if (i > 0) {
                        int m = 60 / i % 60;
                        int h = 24 / (i / 60) % 24;
                        parts = new String[]{m > 0 ? "*/" + m : "*", h > 0 ? "*/" + h : "*", "*", "*", "*"};
                    }
                }
            }
            if (parts.length > 0) {
                this.allowedMinutes = MCast.toIntIntervalValues(parts[0], 0, 59);
            }
            if (parts.length > 1) {
                this.allowedHours = MCast.toIntIntervalValues(parts[1], 0, 23);
            }
            if (parts.length > 2) {
                this.allowedDaysMonth = MCast.toIntIntervalValues(parts[2], 1, 31);
            }
            if (parts.length > 3) {
                this.allowedMonthes = MCast.toIntIntervalValues(parts[3], 0, 11);
            }
            if (parts.length > 4) {
                this.allowedDaysWeek = MCast.toIntIntervalValues(parts[4], 1, 7);
            }
            if (parts.length > 5) {
                if (parts[5].indexOf("disabled") >= 0) {
                    this.disabled = true;
                }
                if (parts[5].indexOf("w") >= 0) {
                    this.onlyWorkingDays = true;
                }
            }
        }

        public long calculateNext(long start) {
            HolidayProviderIfc holidayProvider;
            int[] d;
            if (this.disabled) {
                return -1L;
            }
            Calendar next = Calendar.getInstance();
            next.set(14, 0);
            next.set(13, 0);
            next.add(12, 1);
            if (this.allowedMinutes != null) {
                d = this.findNextAllowed(this.allowedMinutes, next.get(12));
                next.set(12, d[1]);
                if (d[2] == 1) {
                    next.add(11, 1);
                }
            }
            if (this.allowedHours != null) {
                d = this.findNextAllowed(this.allowedHours, next.get(11));
                next.set(11, d[1]);
                if (d[2] == 1) {
                    next.add(5, 1);
                }
            }
            if (this.allowedDaysMonth != null) {
                d = this.findNextAllowed(this.allowedDaysMonth, next.get(5));
                next.set(5, d[1]);
                if (d[2] == 1) {
                    next.add(2, 1);
                }
            }
            if (this.allowedMonthes != null) {
                d = this.findNextAllowed(this.allowedMonthes, next.get(2));
                next.set(2, d[1]);
                if (d[2] == 1) {
                    next.add(1, 1);
                }
            }
            if (this.allowedDaysWeek != null) {
                d = this.findNextAllowed(this.allowedDaysWeek, next.get(7));
                next.set(7, d[1]);
                if (d[2] == 1) {
                    next.add(3, 1);
                }
            }
            if (this.onlyWorkingDays && (holidayProvider = MApi.lookup(HolidayProviderIfc.class)) != null) {
                while (!holidayProvider.isWorkingDay(null, next.getTime())) {
                    next.add(5, 1);
                }
            }
            return next.getTimeInMillis();
        }

        private int[] findNextAllowed(int[] allowed, int current) {
            int i = 0;
            if (allowed == null || allowed.length == 0) {
                return new int[]{i, current, 0};
            }
            for (int a : allowed) {
                if (a >= current) {
                    return new int[]{i, a, 0};
                }
                ++i;
            }
            return new int[]{0, allowed[0], 1};
        }

        public String toString() {
            return this.definition;
        }
    }
}

