/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.logging;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.logging.LevelMapper;
import de.mhus.lib.core.logging.LogEngine;
import de.mhus.lib.core.logging.ParameterMapper;

public class Log {
    protected boolean localTrace = true;
    protected String name;
    protected static LevelMapper levelMapper;
    protected static ParameterMapper parameterMapper;
    protected LogEngine engine = null;
    protected static int maxMsgSize;

    public Log(Object owner) {
        String name = null;
        if (owner == null) {
            name = "?";
        } else if (owner instanceof Class) {
            name = ((Class)owner).getName();
        } else {
            name = String.valueOf(owner);
            if (name == null) {
                name = owner.getClass().getCanonicalName();
            }
        }
        this.name = name;
        this.localTrace = MApi.isTrace(name);
        this.update();
    }

    public void t(Object ... msg) {
        this.log(LEVEL.TRACE, msg);
    }

    public void log(LEVEL level, Object ... msg) {
        if (this.engine == null) {
            return;
        }
        if (levelMapper != null) {
            level = levelMapper.map(this, level, msg);
        }
        switch (level) {
            case DEBUG: {
                if (this.engine.isDebugEnabled()) break;
                return;
            }
            case ERROR: {
                if (this.engine.isErrorEnabled()) break;
                return;
            }
            case FATAL: {
                if (this.engine.isFatalEnabled()) break;
                return;
            }
            case INFO: {
                if (this.engine.isInfoEnabled()) break;
                return;
            }
            case TRACE: {
                if (this.engine.isTraceEnabled()) break;
                return;
            }
            case WARN: {
                if (this.engine.isWarnEnabled()) break;
                return;
            }
            default: {
                return;
            }
        }
        if (parameterMapper != null) {
            msg = parameterMapper.map(this, msg);
        }
        StringBuffer sb = new StringBuffer();
        this.prepare(sb);
        Throwable error = null;
        for (Object o : msg) {
            error = MSystem.serialize(sb, o, error);
            if (maxMsgSize <= 0 || sb.length() <= maxMsgSize) continue;
            sb.setLength(maxMsgSize);
            sb.append("...");
            break;
        }
        switch (level) {
            case DEBUG: {
                this.engine.debug(sb.toString(), error);
                break;
            }
            case ERROR: {
                this.engine.error(sb.toString(), error);
                break;
            }
            case FATAL: {
                this.engine.fatal(sb.toString(), error);
                break;
            }
            case INFO: {
                this.engine.info(sb.toString(), error);
                break;
            }
            case TRACE: {
                this.engine.trace(sb.toString(), error);
                break;
            }
            case WARN: {
                this.engine.warn(sb.toString(), error);
                break;
            }
        }
    }

    public void d(Object ... msg) {
        this.log(LEVEL.DEBUG, msg);
    }

    public void i(Object ... msg) {
        this.log(LEVEL.INFO, msg);
    }

    public void w(Object ... msg) {
        this.log(LEVEL.WARN, msg);
    }

    public void e(Object ... msg) {
        this.log(LEVEL.ERROR, msg);
    }

    public void f(Object ... msg) {
        this.log(LEVEL.FATAL, msg);
    }

    protected void prepare(StringBuffer sb) {
        if (levelMapper != null) {
            levelMapper.prepareMessage(this, sb);
        } else {
            sb.append('[').append(Thread.currentThread().getId()).append(']');
        }
    }

    public void setLocalTrace(boolean localTrace) {
        this.localTrace = localTrace;
    }

    public boolean isLocalTrace() {
        return this.localTrace;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return MSystem.toString(this, this.getName());
    }

    public static Log getLog(Object owner) {
        return MApi.get().lookupLog(owner);
    }

    public void update() {
        this.engine = MApi.get().getLogFactory().getInstance(this.getName());
        this.localTrace = MApi.isTrace(this.name);
        levelMapper = MApi.get().getLogFactory().getLevelMapper();
        parameterMapper = MApi.get().getLogFactory().getParameterMapper();
        maxMsgSize = MApi.get().getLogFactory().getMaxMessageSize();
    }

    public ParameterMapper getParameterMapper() {
        return parameterMapper;
    }

    public boolean isLevelEnabled(LEVEL level) {
        if (this.engine == null) {
            return false;
        }
        if (this.localTrace) {
            level = LEVEL.INFO;
        } else if (levelMapper != null) {
            level = levelMapper.map(this, level, new Object[0]);
        }
        switch (level) {
            case DEBUG: {
                return this.engine.isDebugEnabled();
            }
            case ERROR: {
                return this.engine.isErrorEnabled();
            }
            case FATAL: {
                return this.engine.isFatalEnabled();
            }
            case INFO: {
                return this.engine.isInfoEnabled();
            }
            case TRACE: {
                return this.engine.isTraceEnabled();
            }
            case WARN: {
                return this.engine.isWarnEnabled();
            }
        }
        return false;
    }

    public void close() {
        if (this.engine == null) {
            return;
        }
        this.engine.close();
        this.engine = null;
    }

    static {
        maxMsgSize = 0;
    }

    public static enum LEVEL {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

