/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import de.mhus.lib.core.base.service.TimerIfc;
import java.io.File;
import java.util.TimerTask;

public class FileWatch {
    private File file;
    private TimerIfc timer;
    private long period = 30000L;
    private long modified = -2L;
    private Listener listener;
    private boolean started = false;
    private TimerTask task;
    private long lastRun;
    private boolean startHook;

    public FileWatch(File fileToWatch, Listener listener) {
        this(fileToWatch, null, 30000L, true, listener);
    }

    public FileWatch(File fileToWatch, TimerIfc timer, Listener listener) {
        this(fileToWatch, timer, 30000L, true, listener);
    }

    public FileWatch(File fileToWatch, TimerIfc timer, long period, boolean startHook, Listener listener) {
        this.file = fileToWatch;
        this.timer = timer;
        this.period = period;
        this.startHook = startHook;
        this.listener = listener;
    }

    public FileWatch doStart() {
        if (this.started) {
            return this;
        }
        this.started = true;
        if (this.startHook) {
            this.checkFile();
        }
        if (this.timer != null) {
            this.task = new TimerTask(){

                @Override
                public void run() {
                    FileWatch.this.checkFile();
                }
            };
            this.timer.schedule(this.task, this.period, this.period);
        }
        return this;
    }

    public FileWatch doStop() {
        if (!this.started) {
            return this;
        }
        if (this.task != null) {
            this.task.cancel();
        }
        return this;
    }

    public void checkFile() {
        block10: {
            if (System.currentTimeMillis() - this.lastRun < this.period) {
                return;
            }
            this.lastRun = System.currentTimeMillis();
            try {
                long modSum = 0L;
                if (this.file.exists()) {
                    if (this.file.isFile()) {
                        modSum = this.file.lastModified();
                    } else if (this.file.isDirectory()) {
                        for (File f : this.file.listFiles()) {
                            if (!f.isFile() || f.isHidden()) continue;
                            modSum += f.lastModified();
                        }
                    }
                } else {
                    modSum = -1L;
                }
                if (this.modified != -2L && this.listener != null && this.modified != modSum) {
                    this.listener.onFileChanged(this);
                }
                this.modified = modSum;
            }
            catch (Throwable t) {
                if (this.listener == null) break block10;
                this.listener.onFileWatchError(this, t);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file != null ? this.file.getAbsolutePath() : "?";
    }

    public static interface Listener {
        public void onFileChanged(FileWatch var1);

        public void onFileWatchError(FileWatch var1, Throwable var2);
    }
}

