/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.crypt;

import de.mhus.lib.core.MBigMath;
import de.mhus.lib.core.crypt.AsyncKey;
import java.io.IOException;
import java.math.BigInteger;

public class AsyncUtil {
    public static final BigInteger BYTE_SHIFT = new BigInteger("128");

    public static BigInteger encode(AsyncKey key, BigInteger in) throws IOException {
        if (in.signum() == -1) {
            throw new IOException("Negative values are not allowed");
        }
        BigInteger encoded = MBigMath.binaryPow(in, key.getPublicExponent(), key.getModulus());
        return encoded;
    }

    public static BigInteger[] encodeBytes(AsyncKey key, byte[] in) throws IOException {
        BigInteger[] out = new BigInteger[in.length];
        for (int i = 0; i < in.length; ++i) {
            BigInteger c = new BigInteger(new byte[]{in[i]}).add(BYTE_SHIFT);
            out[i] = AsyncUtil.encode(key, c);
        }
        return out;
    }

    public static BigInteger[] encodeBytes(AsyncKey key, BigInteger[] in) throws IOException {
        BigInteger[] out = new BigInteger[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = AsyncUtil.encode(key, in[i]);
        }
        return out;
    }

    public static BigInteger decode(AsyncKey key, BigInteger in) throws IOException {
        if (in.signum() == -1) {
            throw new IOException("Negative values are not allowed");
        }
        BigInteger decoded = MBigMath.binaryPow(in, key.getPrivateExponent(), key.getModulus());
        return decoded;
    }

    public static BigInteger[] decode(AsyncKey key, BigInteger[] in) throws IOException {
        BigInteger[] out = new BigInteger[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = AsyncUtil.decode(key, in[i]);
        }
        return out;
    }

    public static byte[] decodeBytes(AsyncKey key, BigInteger[] in) throws IOException {
        byte[] out = new byte[in.length];
        for (int i = 0; i < in.length; ++i) {
            out[i] = AsyncUtil.decode(key, in[i]).subtract(BYTE_SHIFT).byteValue();
        }
        return out;
    }
}

