/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.console;

import de.mhus.lib.annotations.activator.DefaultImplementation;
import de.mhus.lib.core.console.ConsoleProgressBar;
import de.mhus.lib.core.console.SimpleConsole;
import de.mhus.lib.core.lang.IBase;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;

@DefaultImplementation(value=SimpleConsole.class)
public abstract class Console
extends PrintStream
implements IBase {
    public static final int DEFAULT_WIDTH = 40;
    public static final int DEFAULT_HEIGHT = 25;
    protected LinkedList<String> history = new LinkedList();

    public Console() {
        this(System.out);
    }

    public Console(PrintStream out) {
        super(out);
    }

    public Console(PrintStream out, boolean flush, String charset) throws UnsupportedEncodingException {
        super((OutputStream)out, flush, charset);
    }

    public static Console create() {
        return new SimpleConsole();
    }

    public String readLine() {
        return this.readLine(this.history);
    }

    public abstract String readLine(LinkedList<String> var1);

    public char[] readPassword() {
        return System.console().readPassword();
    }

    public void cr() {
        this.print('\r');
    }

    public abstract boolean isSupportSize();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract boolean isSupportCursor();

    public abstract void setCursor(int var1, int var2);

    public abstract int getCursorX();

    public abstract int getCursorY();

    public ConsoleProgressBar createProgressBar() {
        return new ConsoleProgressBar(this);
    }

    public abstract boolean isSupportColor();

    public abstract void setColor(COLOR var1, COLOR var2);

    public abstract COLOR getForegroundColor();

    public abstract COLOR getBackgroundColor();

    public abstract boolean isSupportBlink();

    public abstract void setBlink(boolean var1);

    public abstract boolean isBlink();

    public abstract boolean isSupportBold();

    public abstract void setBold(boolean var1);

    public abstract boolean isBold();

    public abstract void cleanup();

    public void printLine() {
        this.printLine('-');
    }

    public void printLine(char c) {
        for (int i = 0; i < this.getWidth(); ++i) {
            this.print(c);
        }
        this.println();
    }

    public static enum COLOR {
        UNKNOWN,
        WHITE,
        BLACK,
        RED,
        GREEN,
        BLUE,
        YELLOW,
        MAGENTA,
        CYAN;

    }
}

