/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.config;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MCollection;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.errors.MException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HashConfig
extends IConfig {
    private static final long serialVersionUID = 1L;
    private HashMap<String, String> properties = null;
    private HashMap<String, LinkedList<IConfig>> children = null;
    private LinkedList<HashConfig> childrenAll = null;
    private String name;
    private IConfig parent;

    public HashConfig() {
        this(null, null);
    }

    public HashConfig(String name, IConfig parent) {
        this.name = name;
        this.parent = parent;
        this.properties = new HashMap();
        this.children = new HashMap();
        this.childrenAll = new LinkedList();
    }

    public HashConfig(Map<String, String> fill) {
        this(null, null);
        if (fill != null) {
            this.properties.putAll(fill);
        }
    }

    public List<String> getPropertyKeys() {
        return MCollection.toList(this.properties.keySet());
    }

    @Override
    public IConfig getNode(String key) {
        LinkedList<IConfig> list = this.children.get(key);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.getFirst();
    }

    @Override
    public List<IConfig> getNodes(String key) {
        LinkedList<IConfig> list = this.children.get(key);
        if (list == null || list.size() == 0) {
            return MCollection.getEmptyList();
        }
        return MCollection.toReadOnlyList(list);
    }

    @Override
    public List<IConfig> getNodes() {
        return MCollection.toReadOnlyList(this.childrenAll);
    }

    public List<String> getNodeKeys() {
        LinkedList<String> out = new LinkedList<String>();
        out.addAll(this.children.keySet());
        return out;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public IConfig createConfig(String key) throws MException {
        HashConfig child = new HashConfig(key, this);
        LinkedList<IConfig> list = this.children.get(key);
        if (list == null) {
            list = new LinkedList();
            this.children.put(key, list);
        }
        list.add(child);
        this.childrenAll.add(child);
        return child;
    }

    public void unlink() throws MException {
        if (this.parent == null) {
            return;
        }
        this.parent.removeConfig(this);
        this.parent = null;
    }

    public IConfig setConfig(String key, HashConfig child) throws MException {
        if (child.parent != null) {
            throw new MException(new Object[]{"Config already linked"});
        }
        LinkedList<IConfig> list = this.children.get(key);
        if (list == null) {
            list = new LinkedList();
            this.children.put(key, list);
        }
        child.parent = this;
        child.name = key;
        list.add(child);
        this.childrenAll.add(child);
        return child;
    }

    @Override
    public int moveConfig(IConfig config, int newPos) throws MException {
        if (!(config instanceof HashConfig)) {
            throw new MException(new Object[]{"not a hashconfig"});
        }
        LinkedList<IConfig> list = this.children.get(config.getName());
        if (list == null || list.size() == 0 || !list.contains(config)) {
            throw new MException(new Object[]{"config not in my list"});
        }
        if (list.size() == 1) {
            if (newPos == -102 || newPos == -103 || newPos == 0) {
                return 0;
            }
            throw new MException(new Object[]{"out of range"});
        }
        if (newPos == -102) {
            list.remove(config);
            list.add(0, (HashConfig)config);
            return 0;
        }
        if (newPos == -103) {
            list.remove(config);
            list.add((HashConfig)config);
            return list.size() - 1;
        }
        if (newPos == -101) {
            int pos = list.indexOf(config);
            if (pos == list.size() - 1) {
                throw new MException(new Object[]{"out of range"});
            }
            list.remove(config);
            list.add(pos + 1, (HashConfig)config);
            return pos + 1;
        }
        if (newPos == -100) {
            int pos = list.indexOf(config);
            if (pos == 0) {
                throw new MException(new Object[]{"out of range"});
            }
            list.remove(config);
            list.add(pos - 1, (HashConfig)config);
            return pos - 1;
        }
        if (newPos < 0 || newPos >= list.size()) {
            throw new MException(new Object[]{"out of range"});
        }
        list.remove(config);
        list.add(newPos, (HashConfig)config);
        return newPos;
    }

    @Override
    public void removeConfig(IConfig config) throws MException {
        if (!(config instanceof HashConfig)) {
            return;
        }
        LinkedList<IConfig> list = this.children.get(config.getName());
        if (list == null) {
            return;
        }
        list.remove(config);
        if (list.size() == 0) {
            this.children.remove(list);
        }
        this.childrenAll.remove(config);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public boolean isProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, MCast.objectToString(value));
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public ResourceNode getParent() {
        return this.parent;
    }

    @Override
    public Set<String> keys() {
        return this.properties.keySet();
    }

    @Override
    public InputStream getInputStream(String key) {
        return null;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public void clear() {
        this.properties.clear();
    }
}

