/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.cfg;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MSystem;

public abstract class CfgValue<T> {
    private String path;
    private T def;
    private T value;
    private Object owner;

    public CfgValue(Object owner, String path, T def) {
        this.owner = owner;
        this.path = path;
        this.def = def;
        MApi.getCfgUpdater().register(this);
        this.update();
    }

    public T value() {
        return this.value == null ? this.def : this.value;
    }

    public String getPath() {
        return this.path;
    }

    public Object getOwner() {
        return this.owner;
    }

    public Class<?> getOwnerClass() {
        if (this.owner == null) {
            return null;
        }
        if (this.owner instanceof Class) {
            return (Class)this.owner;
        }
        return this.owner.getClass();
    }

    public T getDefault() {
        return this.def;
    }

    void update() {
        T newValue = this.loadValue();
        if (MSystem.equals(this.value, newValue)) {
            return;
        }
        this.onPreUpdate(newValue);
        this.value = newValue;
        this.onPostUpdate(this.value);
    }

    protected abstract T loadValue();

    protected abstract T loadValue(String var1);

    protected void onPreUpdate(T newValue) {
    }

    protected void onPostUpdate(T newValue) {
    }

    public boolean isOwner(String name) {
        return MApi.get().getCfgManager().isOwner(this.owner, name);
    }

    public void setValue(String v) {
        T newValue = this.loadValue(v);
        if (newValue == null) {
            return;
        }
        if (MSystem.equals(this.value, newValue)) {
            return;
        }
        this.onPreUpdate(newValue);
        this.value = newValue;
        this.onPostUpdate(this.value);
    }
}

