/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.base.service;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.base.service.TimerIfc;
import de.mhus.lib.core.logging.LevelMapper;
import de.mhus.lib.core.logging.TrailLevelMapper;
import de.mhus.lib.core.schedule.SchedulerJob;
import de.mhus.lib.core.util.TimerTaskSelfControl;
import java.util.Date;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;

public class TimerImpl
extends MLog
implements TimerIfc {
    private Timer timer;
    private LinkedList<TimerTaskWrap> tasks = new LinkedList();

    public TimerImpl(Timer timer) {
        this.timer = timer;
    }

    public int hashCode() {
        return this.timer.hashCode();
    }

    public boolean equals(Object obj) {
        return this.timer.equals(obj);
    }

    @Override
    public void schedule(TimerTask task, long delay) {
        this.log().d("schedule", task, delay);
        this.timer.schedule((TimerTask)new TimerTaskWrap(this, task), delay);
    }

    @Override
    public void schedule(TimerTask task, Date time) {
        this.log().d("schedule", task, time);
        this.timer.schedule((TimerTask)new TimerTaskWrap(this, task), time);
    }

    @Override
    public void schedule(TimerTask task, long delay, long period) {
        this.log().d("schedule", task, delay, period);
        this.timer.schedule((TimerTask)new TimerTaskWrap(this, task), delay, period);
    }

    public String toString() {
        return this.timer.toString();
    }

    @Override
    public void schedule(TimerTask task, Date firstTime, long period) {
        this.log().d("schedule", task, firstTime, period);
        this.timer.schedule((TimerTask)new TimerTaskWrap(this, task), firstTime, period);
    }

    @Override
    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        this.log().d("scheduleAtFixedRate", task, delay, period);
        this.timer.scheduleAtFixedRate((TimerTask)new TimerTaskWrap(this, task), delay, period);
    }

    @Override
    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        this.log().d("scheduleAtFixedRate", task, firstTime, period);
        this.timer.scheduleAtFixedRate((TimerTask)new TimerTaskWrap(this, task), firstTime, period);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        TimerImpl timerImpl = this;
        synchronized (timerImpl) {
            for (TimerTaskWrap task : this.tasks) {
                task.cancelDirect();
            }
        }
    }

    public int purge() {
        return this.timer.purge();
    }

    @Override
    public void schedule(SchedulerJob scheduler) {
        this.schedule((TimerTask)scheduler, 1000L, 1000L);
    }

    private class TimerTaskWrap
    extends TimerTask {
        private TimerTask task;
        private TimerImpl timer;
        private String log;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TimerTaskWrap(TimerImpl timer, TimerTask task) {
            this.task = task;
            this.timer = timer;
            TimerImpl timerImpl2 = timer;
            synchronized (timerImpl2) {
                timer.tasks.add(this);
            }
            LevelMapper lm = MApi.get().getLogFactory().getLevelMapper();
            if (lm != null && lm instanceof TrailLevelMapper) {
                this.log = ((TrailLevelMapper)lm).doSerializeTrail();
            }
        }

        @Override
        public void run() {
            LevelMapper lm;
            try {
                if (this.log != null && (lm = MApi.get().getLogFactory().getLevelMapper()) != null && lm instanceof TrailLevelMapper) {
                    ((TrailLevelMapper)lm).doConfigureTrail(this.log);
                }
                TimerImpl.this.log().t("run", this.task);
                this.task.run();
            }
            catch (Throwable t) {
                TimerImpl.this.log().i("error", this.task.getClass().getCanonicalName(), t);
                if (this.task instanceof TimerTaskSelfControl) {
                    if (((TimerTaskSelfControl)((Object)this.task)).isCancelOnError()) {
                        this.cancel();
                    }
                } else {
                    this.cancel();
                }
            }
            finally {
                if (this.log != null && (lm = MApi.get().getLogFactory().getLevelMapper()) != null && lm instanceof TrailLevelMapper) {
                    ((TrailLevelMapper)lm).doResetTrail();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel() {
            TimerImpl timerImpl = this.timer;
            synchronized (timerImpl) {
                this.timer.tasks.remove(this);
            }
            return super.cancel();
        }

        private void cancelDirect() {
            super.cancel();
        }
    }
}

