/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.basics.Named;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.logging.MLogUtil;
import java.lang.reflect.Field;
import java.util.Observable;
import java.util.Observer;
import java.util.TimerTask;

public abstract class MTimerTask
extends TimerTask
implements Observer,
Named {
    public static final int UNKNOWN = -1;
    public static final int VIRGIN = 0;
    public static final int SCHEDULED = 1;
    public static final int EXECUTED = 2;
    public static final int CANCELLED = 3;
    private boolean canceled = false;
    private String name;

    public MTimerTask() {
        this.setName(MSystem.getClassName(this));
    }

    @Override
    public final void run() {
        boolean error = false;
        try {
            this.doit();
        }
        catch (Throwable t) {
            try {
                this.onError(t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            error = true;
        }
        try {
            this.onFinal(error);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void onError(Throwable t) {
        t.printStackTrace();
    }

    protected void onFinal(boolean isError) {
    }

    public abstract void doit() throws Exception;

    @Override
    public void update(Observable o, Object arg) {
        this.run();
    }

    @Override
    public boolean cancel() {
        this.setCanceled(true);
        return super.cancel();
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static int getStatus(TimerTask task) {
        if (task == null) {
            return -1;
        }
        try {
            Class<?> clazz = task.getClass();
            Field field = MSystem.getDeclaredField(clazz, "state");
            if (field != null) {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                return field.getInt(task);
            }
        }
        catch (Throwable t) {
            MLogUtil.log().d(task, t);
        }
        return -1;
    }
}

