/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

public class MMath {
    public static final int ROTATE_LEFT = 1;
    public static final int ROTATE_RIGHT = 2;

    public static String toBasis36(long value, int digits) {
        boolean minus;
        StringBuffer sb = new StringBuffer();
        boolean bl = minus = value < 0L;
        if (minus) {
            value = -value;
        }
        while (value > 0L) {
            long nr = value % 36L;
            value /= 36L;
            char c = '\u0000';
            c = nr < 10L ? (char)(48L + nr) : (char)(65L + nr - 10L);
            sb.insert(0, c);
        }
        while (sb.length() < digits) {
            sb.insert(0, '0');
        }
        if (minus) {
            sb.insert(0, '-');
        }
        return sb.toString();
    }

    public static String toBasis36WithIdent(long value, long ident, int digits) {
        boolean minus;
        StringBuffer sb = new StringBuffer();
        if (ident < 0L) {
            ident = -ident;
        }
        while (ident > 0L) {
            long nr = ident % 36L;
            ident /= 36L;
            char c = '\u0000';
            c = nr < 10L ? (char)(48L + nr) : (char)(65L + nr - 10L);
            sb.insert(0, c);
        }
        while (sb.length() < 4) {
            sb.insert(0, '0');
        }
        boolean bl = minus = value < 0L;
        if (minus) {
            value = -value;
        }
        while (value > 0L) {
            long nr = value % 36L;
            value /= 36L;
            char c = '\u0000';
            c = nr < 10L ? (char)(48L + nr) : (char)(65L + nr - 10L);
            sb.insert(0, c);
        }
        while (sb.length() < digits) {
            sb.insert(0, '0');
        }
        if (minus) {
            sb.insert(0, '-');
        }
        return sb.toString();
    }

    public static double truncateDecimals(double d, int len) {
        long p = MMath.pow(10L, len);
        long l = (long)(d * (double)p);
        return (double)l / (double)p;
    }

    public static long pow(long a, int b) {
        long result = 1L;
        for (int i = 1; i <= b; ++i) {
            result *= a;
        }
        return result;
    }

    public static int calcMask(int bitstorotate, int direction) {
        int mask = 0;
        if (bitstorotate == 0) {
            return 0;
        }
        int c = Integer.MIN_VALUE;
        mask = c >> bitstorotate;
        if (direction == 2) {
            mask = c >> 32 - bitstorotate;
            mask ^= 0xFFFFFFFF;
        } else {
            mask = c >> bitstorotate;
        }
        return mask;
    }

    private static int rotr(int value, int bitstorotate, int sizet) {
        int tmprslt = 0;
        int mask = 0;
        int target = 0;
        target = value;
        mask = MMath.calcMask(bitstorotate %= sizet, 2);
        tmprslt = value & mask;
        target = value >>> bitstorotate;
        return target |= (tmprslt <<= sizet - bitstorotate);
    }

    private static int rotl(int value, int bitstorotate, int sizet) {
        int tmprslt = 0;
        int mask = 0;
        int target = 0;
        mask = MMath.calcMask(bitstorotate %= sizet, 1);
        tmprslt = value & (mask >>>= 32 - sizet);
        target = value << bitstorotate;
        return target |= (tmprslt >>>= sizet - bitstorotate);
    }

    public static int rotr(int value, int bitstorotate) {
        return MMath.rotr(value, bitstorotate, 32);
    }

    public static short rotr(short value, int bitstorotate) {
        return (short)MMath.rotr(0xFFFF & value, bitstorotate, 16);
    }

    public static byte rotr(byte value, int bitstorotate) {
        return (byte)MMath.rotr(0xFF & value, bitstorotate, 8);
    }

    public static int rotl(int value, int bitstorotate) {
        return MMath.rotl(value, bitstorotate, 32);
    }

    public static short rotl(short value, int bitstorotate) {
        return (short)MMath.rotl(0xFFFF & value, bitstorotate, 16);
    }

    public static byte rotl(byte value, int bitstorotate) {
        return (byte)MMath.rotl(0xFF & value, bitstorotate, 8);
    }
}

