/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MRegistry;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.WeakHashMap;

public class MEventHandler<L>
extends MLog
implements MRegistry<L> {
    private HashMap<L, String> listeners = new HashMap();
    private WeakHashMap<L, String> weak = new WeakHashMap();
    private boolean weakHandler = false;

    public MEventHandler() {
        this(false);
    }

    public MEventHandler(boolean weakHandler) {
        this.weakHandler = weakHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(L listener) {
        if (this.weakHandler) {
            this.registerWeak(listener);
            return;
        }
        HashMap<L, String> hashMap = this.listeners;
        synchronized (hashMap) {
            if (!this.contains(listener)) {
                this.listeners.put(listener, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(L listener) {
        HashMap<L, String> hashMap = this.listeners;
        synchronized (hashMap) {
            this.listeners.remove(listener);
            this.weak.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerWeak(L listener) {
        HashMap<L, String> hashMap = this.listeners;
        synchronized (hashMap) {
            this.weak.put(listener, "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(L listener) {
        MEventHandler mEventHandler = this;
        synchronized (mEventHandler) {
            return this.listeners.containsKey(listener) || this.weak.containsKey(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getListenersArray() {
        Object[] list = null;
        HashMap<L, String> hashMap = this.listeners;
        synchronized (hashMap) {
            Object[] list1 = this.weakHandler ? null : this.listeners.keySet().toArray();
            Object[] list2 = this.weak.keySet().toArray();
            if (list1 == null) {
                list = list2;
            } else if (list2.length == 0) {
                list = list1;
            } else if (list1.length == 0) {
                list = list2;
            } else {
                list = new Object[list1.length + list2.length];
                System.arraycopy(list1, 0, list, 0, list1.length);
                System.arraycopy(list2, 0, list, list1.length, list2.length);
            }
        }
        return list;
    }

    public Iterable<L> getListeners() {
        if (this.weakHandler || this.listeners.size() == 0) {
            return this.weak.keySet();
        }
        if (this.weak.size() == 0) {
            return this.listeners.keySet();
        }
        LinkedList<L> ll = new LinkedList<L>(this.listeners.keySet());
        ll.addAll(this.weak.keySet());
        return ll;
    }

    public int size() {
        return this.listeners.size() + this.weak.size();
    }

    public boolean isWeakHandler() {
        return this.weakHandler;
    }

    public void fire() {
        this.fire(null, new Object[0]);
    }

    public void fire(Object event, Object ... values) {
        for (Object obj : this.getListenersArray()) {
            try {
                this.onFire(obj, event, values);
            }
            catch (Throwable t) {
                this.log().d(obj, event, values);
            }
        }
    }

    public void fireMethod(Method method, Object ... values) {
        for (Object obj : this.getListenersArray()) {
            try {
                method.invoke(obj, values);
            }
            catch (Throwable t) {
                this.log().d(obj, method, values, t);
            }
        }
    }

    public void onFire(L listener, Object event, Object ... values) {
    }
}

