/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.util.EmptyList;
import de.mhus.lib.core.util.ReadOnlyList;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;

public class MCollection {
    public static final List<?> EMPTY_LIST = new EmptyList();

    public static boolean contains(Object[] array, Object item) {
        if (array == null) {
            return false;
        }
        for (Object o : array) {
            if ((item != null || o != null) && (o == null || !o.equals(item))) continue;
            return true;
        }
        return false;
    }

    public static <T> void copyArray(T[] array, Collection<T> list) {
        if (array == null || list == null) {
            return;
        }
        for (T item : array) {
            if (item == null) continue;
            list.add(item);
        }
    }

    public static <T> void removeDuplicates(List<T> list) {
        HashSet<T> encountered = new HashSet<T>();
        Iterator<T> iter = list.iterator();
        while (iter.hasNext()) {
            T t = iter.next();
            boolean first = encountered.add(t);
            if (first) continue;
            iter.remove();
        }
    }

    public static <T> void removeDuplicates(List<T> list, Comparator<T> comparator) {
        HashSet<T> encountered = new HashSet<T>();
        Iterator<T> iter = list.iterator();
        while (iter.hasNext()) {
            T t = iter.next();
            boolean removed = false;
            for (Object e : encountered) {
                if (comparator.compare(t, e) != 0) continue;
                iter.remove();
                removed = true;
                break;
            }
            if (removed) continue;
            encountered.add(t);
        }
    }

    @SafeVarargs
    public static <T> T[] append(T[] array, T ... newElements) {
        if (newElements == null || newElements.length == 0) {
            return array;
        }
        if (array == null) {
            return newElements;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + newElements.length);
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(newElements, 0, newArray, array.length, newElements.length);
        return newArray;
    }

    public static int[] order(int[] array, boolean unique) {
        if (unique) {
            HashSet<Integer> set = new HashSet<Integer>();
            for (int i : array) {
                set.add(i);
            }
            int[] out = new int[set.size()];
            Iterator iter = set.iterator();
            for (int i = 0; i < out.length; ++i) {
                out[i] = (Integer)iter.next();
            }
            return out;
        }
        LinkedList<Integer> list = new LinkedList<Integer>();
        for (int i : array) {
            list.add(i);
        }
        Collections.sort(list);
        int[] out = new int[list.size()];
        Iterator iter = list.iterator();
        for (int i = 0; i < out.length; ++i) {
            out[i] = (Integer)iter.next();
        }
        return out;
    }

    public static long[] order(long[] array, boolean unique) {
        if (unique) {
            HashSet<Long> set = new HashSet<Long>();
            for (long i : array) {
                set.add(i);
            }
            long[] out = new long[set.size()];
            Iterator iter = set.iterator();
            for (int i = 0; i < out.length; ++i) {
                out[i] = (Long)iter.next();
            }
            return out;
        }
        LinkedList<Long> list = new LinkedList<Long>();
        for (long i : array) {
            list.add(i);
        }
        Collections.sort(list);
        long[] out = new long[list.size()];
        Iterator iter = list.iterator();
        for (int i = 0; i < out.length; ++i) {
            out[i] = (Long)iter.next();
        }
        return out;
    }

    public static int[] fillIntArray(int from, int to) {
        int[] out = new int[to - from];
        for (int l = 0; l < out.length; ++l) {
            out[l] = l + from;
        }
        return out;
    }

    public static Map<String, String> toStringMap(Map<Object, Object> in, boolean ignoreNull) {
        HashMap<String, String> out = new HashMap<String, String>();
        for (Map.Entry<Object, Object> e : in.entrySet()) {
            if (e.getValue() == null) {
                if (ignoreNull) continue;
                out.put(e.getKey().toString(), "");
                continue;
            }
            out.put(e.getKey().toString(), e.getValue().toString());
        }
        return out;
    }

    public static Map<String, String> toStringMap(IProperties in, boolean ignoreNull) {
        HashMap<String, String> out = new HashMap<String, String>();
        for (Map.Entry e : in) {
            if (e.getValue() == null) {
                if (ignoreNull) continue;
                out.put((String)e.getKey(), "");
                continue;
            }
            out.put((String)e.getKey(), e.getValue().toString());
        }
        return out;
    }

    public static <T> List<T> toList(T[] array) {
        LinkedList<T> out = new LinkedList<T>();
        for (T item : array) {
            out.add(item);
        }
        return out;
    }

    public static <T> TreeSet<T> toTreeSet(T[] items) {
        TreeSet<T> ret = new TreeSet<T>();
        for (T item : items) {
            if (item == null) continue;
            ret.add(item);
        }
        return ret;
    }

    public static <T> HashSet<T> toHashSet(T[] items) {
        HashSet<T> ret = new HashSet<T>();
        for (T item : items) {
            if (item == null) continue;
            ret.add(item);
        }
        return ret;
    }

    public static <T> void addAll(List<T> list, T[] items) {
        for (T i : items) {
            if (i == null) continue;
            list.add(i);
        }
    }

    public static <T> void addAll(Set<T> list, T[] items) {
        for (T i : items) {
            if (i == null) continue;
            list.add(i);
        }
    }

    public static <T extends List<?>> T getEmptyList() {
        return (T)EMPTY_LIST;
    }

    public static <T> List<T> toReadOnlyList(List<? extends T> in) {
        return new ReadOnlyList<T>(in);
    }

    public static <T> List<T> toList(Collection<? extends T> set) {
        LinkedList<? extends T> out = new LinkedList<T>();
        out.addAll(set);
        return out;
    }

    public static <T> Set<T> toSet(Collection<? extends T> list) {
        HashSet<? extends T> set = new HashSet<T>();
        set.addAll(list);
        return set;
    }

    public static boolean contains(String list, char separator, String item) {
        if (list == null || item == null) {
            return false;
        }
        String s = Pattern.quote(String.valueOf(separator));
        return list.matches("(.*" + s + "|)" + Pattern.quote(item) + "(" + s + ".*|)");
    }

    public static String append(String list, char separator, String item) {
        if (item == null) {
            return list;
        }
        if (MString.isEmpty(list)) {
            return item;
        }
        return list + separator + item;
    }

    public static String set(String list, char separator, String item) {
        if (item == null) {
            return list;
        }
        if (MString.isEmpty(list)) {
            return item;
        }
        if (MCollection.contains(list, separator, item)) {
            return list;
        }
        return list + separator + item;
    }

    public static String remove(String list, char separator, String item) {
        if (list == null || item == null || list.length() == 0) {
            return list;
        }
        if (list.equals(item)) {
            return "";
        }
        if (list.startsWith(item + separator)) {
            return list.substring(item.length() + 1);
        }
        if (list.endsWith(separator + item)) {
            return list.substring(0, list.length() - 1 - item.length());
        }
        return list.replaceFirst(Pattern.quote(separator + item + separator), String.valueOf(separator));
    }

    public static <K, V> Map<K, V> sorted(Map<K, V> in) {
        return new TreeMap<K, V>(in);
    }

    public static <K> List<K> sorted(List<K> in) {
        if (in != null && in.size() > 0 && in.get(0) instanceof Comparable) {
            LinkedList<Comparable> l = new LinkedList<Comparable>();
            for (K item : in) {
                if (!(item instanceof Comparable)) continue;
                l.add((Comparable)item);
            }
            Collections.sort(l);
            return l;
        }
        if (in == null) {
            return new LinkedList();
        }
        return in;
    }

    public static <K, V> Map<K, V> sorted(Map<K, V> in, Comparator<K> comp) {
        TreeMap<K, V> out = new TreeMap<K, V>(comp);
        out.putAll(in);
        return out;
    }

    public static <K> List<K> sorted(List<K> in, Comparator<K> comp) {
        if (in != null && in.size() > 0) {
            LinkedList<K> l = new LinkedList<K>(in);
            Collections.sort(l, comp);
            return l;
        }
        return new LinkedList();
    }
}

