package de.mhus.lib.core.cfg;

import de.mhus.lib.core.MApi;
import de.mhus.lib.core.directory.ResourceNode;

public class CfgString extends CfgValue<String>{

	public CfgString(Object owner, String path, String def) {
		super(owner, path, def);
	}

	@Override
	protected String loadValue() {
		int p = getPath().indexOf('@');
		if (p < 0) 
			return MApi.getCfg(getOwner()).getString(getPath(), getDefault());
		ResourceNode node = MApi.getCfg(getOwner()).getNodeByPath(getPath().substring(0, p));
		if (node == null) return getDefault();
		return node.getString(getPath().substring(p+1), getDefault());
	}

	@Override
	protected String loadValue(String value) {
		return value;
	}

}
