/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.strategy;

import de.mhus.lib.core.MLog;
import de.mhus.lib.core.strategy.NotSuccessful;
import de.mhus.lib.core.strategy.Operation;
import de.mhus.lib.core.strategy.OperationResult;
import de.mhus.lib.core.strategy.TaskContext;

public abstract class AbstractOperation
extends MLog
implements Operation {
    private Object owner;

    @Override
    public final OperationResult doExecute(TaskContext context) throws Exception {
        this.log().d("execute", context.getParameters());
        if (!this.hasAccess()) {
            this.log().d("access denied", context, context.getErrorMessage());
            return new NotSuccessful(this, "access denied", -401L);
        }
        if (!this.canExecute(context)) {
            this.log().d("execution denied", context.getErrorMessage());
            return new NotSuccessful(this, context.getErrorMessage() != null ? context.getErrorMessage() : "can't execute", -12L);
        }
        OperationResult ret = this.doExecute2(context);
        this.log().d("result", ret);
        return ret;
    }

    protected abstract OperationResult doExecute2(TaskContext var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBusy() {
        AbstractOperation abstractOperation = this;
        synchronized (abstractOperation) {
            return this.owner != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBusy(Object owner) {
        AbstractOperation abstractOperation = this;
        synchronized (abstractOperation) {
            if (this.owner != null) {
                return false;
            }
            this.owner = owner;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseBusy(Object owner) {
        AbstractOperation abstractOperation = this;
        synchronized (abstractOperation) {
            if (this.owner == null) {
                return true;
            }
            if (this.owner != owner) {
                return false;
            }
            this.owner = null;
        }
        return true;
    }
}

