/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.schedule;

import de.mhus.lib.basics.Named;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.MTimerTask;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.schedule.Scheduler;
import de.mhus.lib.core.strategy.DefaultTaskContext;
import de.mhus.lib.core.strategy.NotSuccessful;
import de.mhus.lib.core.strategy.Operation;
import de.mhus.lib.core.strategy.OperationDescription;
import de.mhus.lib.core.strategy.OperationResult;
import de.mhus.lib.core.strategy.TaskContext;
import java.util.Observer;

public abstract class SchedulerJob
extends MTimerTask
implements Operation {
    public static final long CALCULATE_NEXT = 0L;
    public static final long DISABLED_TIME = -1L;
    public static final long REMOVE_TIME = -2L;
    protected static Log log = Log.getLog(SchedulerJob.class);
    private Object owner;
    private long nextExecutionTime = 0L;
    protected MyTaskContext context = new MyTaskContext();
    private boolean done = false;
    private Observer task;
    private long lastExecutionStart;
    private long lastExecutionStop;
    private long scheduledTime;
    private long timeoutInMinutes;
    private Thread thread;

    public SchedulerJob(Observer task) {
        this.setTask(task);
        if (task == null) {
            this.setName("null");
        }
        if (task instanceof Named) {
            this.setName(((Named)task).getName());
        } else {
            this.setName(MSystem.getClassName(task));
        }
    }

    public SchedulerJob(String name, Observer task) {
        this.setTask(task);
        this.setName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTick() {
        SchedulerJob schedulerJob;
        if (!this.isCanceled() && this.task instanceof MTimerTask && ((MTimerTask)this.task).isCanceled()) {
            this.cancel();
        }
        if (this.isCanceled()) {
            return;
        }
        if (this.getNextExecutionTime() == 0L) {
            schedulerJob = this;
            synchronized (schedulerJob) {
                this.doCaclulateNextExecution();
            }
        }
        if (this.isExecutionTimeReached()) {
            this.lastExecutionStart = System.currentTimeMillis();
            this.thread = Thread.currentThread();
            try {
                this.doExecute(this.context);
            }
            catch (Throwable e) {
                this.doError(e);
            }
            this.thread = null;
            this.lastExecutionStop = System.currentTimeMillis();
            this.context.clear();
            this.setDone(true);
            schedulerJob = this;
            synchronized (schedulerJob) {
                this.doCaclulateNextExecution();
            }
        }
    }

    protected abstract void doCaclulateNextExecution();

    @Override
    public final OperationResult doExecute(TaskContext context) throws Exception {
        log.d("execute", context.getParameters());
        if (!this.hasAccess()) {
            log.d("access denied", context, context.getErrorMessage());
            return new NotSuccessful(this, "access denied", -401L);
        }
        if (!this.canExecute(context)) {
            log.d("execution denied", context.getErrorMessage());
            return new NotSuccessful(this, context.getErrorMessage() != null ? context.getErrorMessage() : "can't execute", -12L);
        }
        OperationResult ret = this.doExecute2(context);
        log.d("result", ret);
        return ret;
    }

    protected OperationResult doExecute2(TaskContext context) throws Exception {
        if (this.task != null) {
            this.task.update(null, context);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBusy() {
        SchedulerJob schedulerJob = this;
        synchronized (schedulerJob) {
            return this.owner != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setBusy(Object owner) {
        SchedulerJob schedulerJob = this;
        synchronized (schedulerJob) {
            if (this.owner != null) {
                return false;
            }
            this.owner = owner;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseBusy(Object owner) {
        SchedulerJob schedulerJob = this;
        synchronized (schedulerJob) {
            if (this.owner == null) {
                return true;
            }
            if (this.owner != owner) {
                return false;
            }
            this.owner = null;
        }
        return true;
    }

    public Object getOwner() {
        return this.owner;
    }

    protected boolean isExecutionTimeReached() {
        return this.getNextExecutionTime() > 0L && System.currentTimeMillis() >= this.getNextExecutionTime();
    }

    public boolean isDone() {
        return this.done;
    }

    protected void setDone(boolean done) {
        this.done = done;
    }

    @Override
    public boolean hasAccess() {
        return true;
    }

    @Override
    public boolean canExecute(TaskContext context) {
        return true;
    }

    @Override
    public OperationDescription getDescription() {
        return null;
    }

    public Observer getTask() {
        return this.task;
    }

    protected void setTask(Observer task) {
        this.task = task;
    }

    @Override
    public void doit() throws Exception {
        this.doTick();
    }

    public long getNextExecutionTime() {
        return this.nextExecutionTime;
    }

    protected void doError(Throwable t) {
        log.e(this.getName(), t);
    }

    protected void doSchedule(Scheduler scheduler) {
        this.doReschedule(scheduler, this.getNextExecutionTime());
    }

    protected void doReschedule(Scheduler scheduler, long time) {
        this.setNextExecutionTime(time);
        if (this.isCanceled()) {
            return;
        }
        if (this.getNextExecutionTime() == 0L) {
            this.doCaclulateNextExecution();
        }
        if (this.getNextExecutionTime() == -2L) {
            return;
        }
        if (this.getNextExecutionTime() == -1L) {
            this.setScheduledTime(System.currentTimeMillis() + 86400000L);
            scheduler.getQueue().removeJob(this);
            scheduler.getQueue().doSchedule(this);
            return;
        }
        this.setScheduledTime(this.getNextExecutionTime());
        scheduler.getQueue().removeJob(this);
        scheduler.getQueue().doSchedule(this);
    }

    public long getLastExecutionStart() {
        return this.lastExecutionStart;
    }

    public long getLastExecutionStop() {
        return this.lastExecutionStop;
    }

    public long getScheduledTime() {
        return this.scheduledTime;
    }

    protected void setScheduledTime(long scheduledTime) {
        this.scheduledTime = scheduledTime;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public long getTimeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public void setTimeoutInMinutes(long timeoutInMinutes) {
        this.timeoutInMinutes = timeoutInMinutes;
    }

    public void doTimeoutReached() {
    }

    public Thread getThread() {
        return this.thread;
    }

    public void setNextExecutionTime(long nextExecutionTime) {
        this.nextExecutionTime = nextExecutionTime;
    }

    protected static class MyTaskContext
    extends DefaultTaskContext {
        protected MyTaskContext() {
        }

        public void clear() {
            this.errorMessage = null;
        }
    }
}

