/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.schedule;

import de.mhus.lib.basics.Named;
import de.mhus.lib.core.MLog;
import de.mhus.lib.core.MThread;
import de.mhus.lib.core.schedule.QueueList;
import de.mhus.lib.core.schedule.SchedulerJob;
import de.mhus.lib.core.schedule.SchedulerQueue;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class Scheduler
extends MLog
implements Named {
    private Timer timer;
    SchedulerQueue queue = new QueueList();
    private String name = Scheduler.class.getCanonicalName();
    private LinkedList<SchedulerJob> running = new LinkedList();
    private long nextTimeoutCheck;

    public Scheduler() {
    }

    public Scheduler(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void start() {
        if (this.timer != null) {
            return;
        }
        this.timer = new Timer(this.name, true);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Scheduler.this.doTick();
            }
        }, 1000L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTick() {
        long time;
        List<SchedulerJob> pack = this.queue.removeJobs(System.currentTimeMillis());
        if (pack != null) {
            for (SchedulerJob job : pack) {
                try {
                    this.doExecuteJob(job);
                }
                catch (Throwable t) {
                    job.doError(t);
                }
            }
        }
        if (this.nextTimeoutCheck < (time = System.currentTimeMillis())) {
            LinkedList<SchedulerJob> linkedList = this.running;
            synchronized (linkedList) {
                try {
                    for (SchedulerJob job : this.running) {
                        long timeout = job.getTimeoutInMinutes() * 60000L;
                        if (timeout <= 0L || timeout + job.getLastExecutionStart() > time) continue;
                        try {
                            if (!job.isBusy()) continue;
                            job.doTimeoutReached();
                        }
                        catch (Throwable t) {
                            job.doError(t);
                        }
                    }
                }
                catch (ConcurrentModificationException concurrentModificationException) {
                    // empty catch block
                }
                this.nextTimeoutCheck = time + 60000L;
            }
        }
    }

    protected void doExecuteJob(SchedulerJob job) {
        if (!job.setBusy(this)) {
            return;
        }
        new MThread(new MyExecutor(job)).start();
    }

    public void stop() {
        if (this.timer == null) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
    }

    public void schedule(SchedulerJob scheduler) {
        scheduler.doSchedule(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SchedulerJob> getRunningJobs() {
        LinkedList<SchedulerJob> linkedList = this.running;
        synchronized (linkedList) {
            return new LinkedList<SchedulerJob>(this.running);
        }
    }

    public List<SchedulerJob> getScheduledJobs() {
        return this.queue.getJobs();
    }

    public SchedulerQueue getQueue() {
        return this.queue;
    }

    private class MyExecutor
    implements Runnable {
        private SchedulerJob job;

        public MyExecutor(SchedulerJob job) {
            this.job = job;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList linkedList = Scheduler.this.running;
            synchronized (linkedList) {
                Scheduler.this.running.add(this.job);
            }
            try {
                if (this.job != null && !this.job.isCanceled()) {
                    this.job.doTick();
                }
            }
            catch (Throwable t) {
                this.job.doError(t);
            }
            finally {
                linkedList = Scheduler.this.running;
                synchronized (linkedList) {
                    Scheduler.this.running.remove(this.job);
                }
                this.job.releaseBusy(Scheduler.this);
            }
            try {
                this.job.doSchedule(Scheduler.this);
            }
            catch (Throwable t) {
                this.job.doError(t);
            }
        }
    }
}

