/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.pojo;

import de.mhus.lib.core.IProperties;
import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MDate;
import de.mhus.lib.core.MProperties;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MXml;
import de.mhus.lib.core.cast.Caster;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.pojo.DefaultFilter;
import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.core.pojo.PojoModel;
import de.mhus.lib.core.pojo.PojoModelFactory;
import de.mhus.lib.core.pojo.PojoParser;
import de.mhus.lib.core.util.Base64;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;

public class MPojo {
    private static final int MAX_LEVEL = 10;
    private static Log log = Log.getLog(MPojo.class);
    private static PojoModelFactory defaultModelFactory;

    public static synchronized PojoModelFactory getDefaultModelFactory() {
        if (defaultModelFactory == null) {
            defaultModelFactory = new PojoModelFactory(){

                @Override
                public PojoModel createPojoModel(Class<?> pojoClass) {
                    PojoModel model = new PojoParser().parse(pojoClass, "_", null).filter(new DefaultFilter(true, false, false, false, true)).getModel();
                    return model;
                }
            };
        }
        return defaultModelFactory;
    }

    public static void pojoToJson(Object from, ObjectNode to) throws IOException {
        MPojo.pojoToJson(from, to, MPojo.getDefaultModelFactory());
    }

    public static void pojoToJson(Object from, ObjectNode to, PojoModelFactory factory) throws IOException {
        MPojo.pojoToJson(from, to, factory, 0);
    }

    public static void pojoToJson(Object from, ObjectNode to, PojoModelFactory factory, int level) throws IOException {
        if (level > 10) {
            return;
        }
        PojoModel model = factory.createPojoModel(from.getClass());
        for (PojoAttribute attr : model) {
            Object value = attr.get(from);
            String name = attr.getName();
            MPojo.setJsonValue(to, name, value, factory, false, level + 1);
        }
    }

    public static void addJsonValue(ArrayNode to, Object value, PojoModelFactory factory, boolean deep, int level) throws IOException {
        if (level > 10) {
            return;
        }
        if (value == null) {
            to.addNull();
        } else if (value instanceof Boolean) {
            to.add(((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            to.add(((Integer)value).intValue());
        } else if (value instanceof String) {
            to.add((String)value);
        } else if (value instanceof Long) {
            to.add(((Long)value).longValue());
        } else if (value instanceof byte[]) {
            to.add((byte[])value);
        } else if (value instanceof Float) {
            to.add(((Float)value).floatValue());
        } else if (value instanceof BigDecimal) {
            to.add((BigDecimal)value);
        } else if (value instanceof JsonNode) {
            to.add((JsonNode)value);
        } else if (value.getClass().isEnum()) {
            to.add(((Enum)value).ordinal());
        } else if (value instanceof Map) {
            ObjectNode obj = to.objectNode();
            to.add((JsonNode)obj);
            for (Map.Entry entry : ((Map)value).entrySet()) {
                MPojo.setJsonValue(obj, String.valueOf(entry.getKey()), entry.getValue(), factory, true, level + 1);
            }
        } else if (value instanceof Collection) {
            ArrayNode array = to.arrayNode();
            to.add((JsonNode)array);
            for (Object o : (Collection)value) {
                MPojo.addJsonValue(array, o, factory, true, level + 1);
            }
        } else if (deep) {
            ObjectNode too = to.objectNode();
            to.add((JsonNode)too);
            MPojo.pojoToJson(value, too, null, level + 1);
        } else {
            to.add(String.valueOf(value));
        }
    }

    public static void setJsonValue(ObjectNode to, String name, Object value, PojoModelFactory factory, boolean deep, int level) throws IOException {
        if (level > 10) {
            return;
        }
        if (value == null) {
            to.putNull(name);
        } else if (value instanceof Boolean) {
            to.put(name, ((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            to.put(name, ((Integer)value).intValue());
        } else if (value instanceof String) {
            to.put(name, (String)value);
        } else if (value instanceof Long) {
            to.put(name, ((Long)value).longValue());
        } else if (value instanceof byte[]) {
            to.put(name, (byte[])value);
        } else if (value instanceof Float) {
            to.put(name, ((Float)value).floatValue());
        } else if (value instanceof Date) {
            to.put(name, ((Date)value).getTime());
            to.put(name + "_", MDate.toIso8601((Date)value));
        } else if (value instanceof BigDecimal) {
            to.put(name, (BigDecimal)value);
        } else if (value instanceof JsonNode) {
            to.put(name, (JsonNode)value);
        } else if (value.getClass().isEnum()) {
            to.put(name, ((Enum)value).ordinal());
            to.put(name + "_", ((Enum)value).name());
        } else if (value instanceof Map) {
            ObjectNode obj = to.objectNode();
            to.put(name, (JsonNode)obj);
            for (Map.Entry entry : ((Map)value).entrySet()) {
                MPojo.setJsonValue(obj, String.valueOf(entry.getKey()), entry.getValue(), factory, true, level + 1);
            }
        } else if (value instanceof Collection) {
            ArrayNode array = to.arrayNode();
            to.put(name, (JsonNode)array);
            for (Object o : (Collection)value) {
                MPojo.addJsonValue(array, o, factory, true, level + 1);
            }
        } else if (deep) {
            ObjectNode too = to.objectNode();
            to.put(name, (JsonNode)too);
            MPojo.pojoToJson(value, too, factory, level + 1);
        } else {
            to.put(name, String.valueOf(value));
        }
    }

    public static void jsonToPojo(JsonNode from, Object to) throws IOException {
        MPojo.jsonToPojo(from, to, MPojo.getDefaultModelFactory());
    }

    public static void jsonToPojo(JsonNode from, Object to, PojoModelFactory factory) throws IOException {
        PojoModel model = factory.createPojoModel(to.getClass());
        for (PojoAttribute attr : model) {
            String name = attr.getName();
            Class<?> type = attr.getType();
            JsonNode json = from.get(name);
            try {
                if (json == null || !attr.canWrite()) continue;
                if (type == Boolean.class || type == Boolean.TYPE) {
                    attr.set(to, json.getValueAsBoolean(false));
                    continue;
                }
                if (type == Integer.class || type == Integer.TYPE) {
                    attr.set(to, json.getValueAsInt(0));
                    continue;
                }
                if (type == String.class) {
                    attr.set(to, json.getValueAsText());
                    continue;
                }
                if (type == UUID.class) {
                    try {
                        attr.set(to, UUID.fromString(json.getValueAsText()));
                    }
                    catch (IllegalArgumentException e) {
                        attr.set(to, null);
                    }
                    continue;
                }
                if (type.isEnum()) {
                    Object c;
                    ?[] cons = type.getEnumConstants();
                    int ord = json.getValueAsInt(0);
                    Object t = c = cons.length > 0 ? (Object)cons[0] : null;
                    if (ord >= 0 && ord < cons.length) {
                        c = cons[ord];
                    }
                    attr.set(to, c);
                    continue;
                }
                attr.set(to, json.getValueAsText());
            }
            catch (Throwable t) {
                System.out.println("ERROR " + name);
                t.printStackTrace();
            }
        }
    }

    public static void pojoToXml(Object from, Element to) throws IOException {
        MPojo.pojoToXml(from, to, MPojo.getDefaultModelFactory());
    }

    public static void pojoToXml(Object from, Element to, PojoModelFactory factory) throws IOException {
        MPojo.pojoToXml(from, to, factory, 0);
    }

    public static void pojoToXml(Object from, Element to, PojoModelFactory factory, int level) throws IOException {
        if (level > 10) {
            return;
        }
        PojoModel model = factory.createPojoModel(from.getClass());
        for (PojoAttribute attr : model) {
            Object value = attr.get(from);
            String name = attr.getName();
            Element a = to.getOwnerDocument().createElement("attribute");
            to.appendChild(a);
            a.setAttribute("name", name);
            if (value == null) {
                a.setAttribute("null", "true");
                continue;
            }
            if (value instanceof Boolean) {
                a.setAttribute("boolean", MCast.toString((Boolean)value));
                continue;
            }
            if (value instanceof Integer) {
                a.setAttribute("int", MCast.toString((Integer)value));
                continue;
            }
            if (value instanceof Long) {
                a.setAttribute("long", MCast.toString((Long)value));
                continue;
            }
            if (value instanceof Date) {
                a.setAttribute("date", MCast.toString(((Date)value).getTime()));
                continue;
            }
            if (value instanceof String) {
                if (MPojo.hasValidChars((String)value)) {
                    a.setAttribute("string", (String)value);
                    continue;
                }
                a.setAttribute("encoding", "base64");
                a.setAttribute("string", Base64.encode((String)value));
                continue;
            }
            if (value.getClass().isEnum()) {
                a.setAttribute("enum", MCast.toString(((Enum)value).ordinal()));
                a.setAttribute("value", ((Enum)value).name());
                continue;
            }
            if (value instanceof UUID) {
                a.setAttribute("uuid", ((UUID)value).toString());
                continue;
            }
            if (value instanceof Serializable) {
                a.setAttribute("serializable", "true");
                CDATASection cdata = a.getOwnerDocument().createCDATASection("");
                String data = MCast.toBinaryString(MCast.toBinary(value));
                cdata.setData(data);
                a.appendChild(cdata);
                continue;
            }
            a.setAttribute("type", value.getClass().getCanonicalName());
            MPojo.pojoToXml(value, a, factory, level + 1);
        }
    }

    private static boolean hasValidChars(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\n' || c == '\r' || c == '\t' || c >= ' ' && c <= '\ud7ff') continue;
            return false;
        }
        return true;
    }

    public static void xmlToPojo(Element from, Object to, MActivator act) throws IOException {
        MPojo.xmlToPojo(from, to, MPojo.getDefaultModelFactory(), act);
    }

    public static void xmlToPojo(Element from, Object to, PojoModelFactory factory, MActivator act) throws IOException {
        PojoModel model = factory.createPojoModel(to.getClass());
        HashMap<String, Element> index = new HashMap<String, Element>();
        for (Element e : MXml.getLocalElementIterator(from, "attribute")) {
            index.put(e.getAttribute("name"), e);
        }
        for (PojoAttribute attr : model) {
            CDATASection cdata;
            Object obj;
            String name = attr.getName();
            Element a = (Element)index.get(name);
            if (a == null) {
                log.d("attribute not found", name, to.getClass());
                continue;
            }
            String value = a.getAttribute("null");
            if (MString.isSet(value) && value.equals("true")) {
                attr.set(to, null);
                continue;
            }
            if (a.hasAttribute("string")) {
                String value2;
                String data = a.getAttribute("encoding");
                if ("base64".equals(data)) {
                    value2 = new String(Base64.decode(a.getAttribute("string")));
                    attr.set(to, value2);
                    continue;
                }
                value2 = a.getAttribute("string");
                attr.set(to, value2);
                continue;
            }
            if (a.hasAttribute("boolean")) {
                value = a.getAttribute("boolean");
                attr.set(to, MCast.toboolean(value, false));
                continue;
            }
            if (a.hasAttribute("int")) {
                value = a.getAttribute("int");
                attr.set(to, MCast.toint(value, 0));
                continue;
            }
            if (a.hasAttribute("long")) {
                value = a.getAttribute("long");
                attr.set(to, MCast.tolong(value, 0L));
                continue;
            }
            if (a.hasAttribute("date")) {
                value = a.getAttribute("date");
                obj = new Date();
                ((Date)obj).setTime(MCast.tolong(value, 0L));
                attr.set(to, obj);
                continue;
            }
            if (a.hasAttribute("uuid")) {
                value = a.getAttribute("uuid");
                try {
                    attr.set(to, UUID.fromString(value));
                }
                catch (Throwable t) {
                    log.d(name, t);
                }
                continue;
            }
            if (a.hasAttribute("enum")) {
                value = a.getAttribute("enum");
                attr.set(to, MCast.toint(value, 0));
                continue;
            }
            if ("true".equals(a.getAttribute("serializable")) && (cdata = MXml.findCDataSection(a)) != null) {
                String data = cdata.getData();
                try {
                    Object obj2 = MCast.fromBinary(MCast.fromBinaryString(data));
                    attr.set(to, obj2);
                }
                catch (ClassNotFoundException e1) {
                    throw new IOException(e1);
                }
            }
            if (!a.hasAttribute("type")) continue;
            value = a.getAttribute("type");
            try {
                obj = act.createObject(value);
                MPojo.xmlToPojo(a, obj, factory, act);
                attr.set(to, obj);
            }
            catch (Exception e1) {
                log.d(name, to.getClass(), e1);
            }
        }
    }

    public static String toFunctionName(String in, boolean firstUpper, String def) {
        if (MString.isEmpty(in)) {
            return def;
        }
        boolean first = firstUpper;
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_') {
                if (first) {
                    c = Character.toUpperCase(c);
                }
                first = false;
                out.append(c);
                continue;
            }
            if (!first && c >= '0' && c <= '9') {
                out.append(c);
                continue;
            }
            first = true;
        }
        if (out.length() == 0) {
            return def;
        }
        return out.toString();
    }

    public static IProperties pojoToProperties(Object from) throws IOException {
        return MPojo.pojoToProperties(from, MPojo.getDefaultModelFactory());
    }

    public static IProperties pojoToProperties(Object from, PojoModelFactory factory) throws IOException {
        MProperties out = new MProperties();
        PojoModel model = factory.createPojoModel(from.getClass());
        for (PojoAttribute attr : model) {
            Object value = attr.get(from);
            String name = attr.getName();
            Class<?> type = attr.getType();
            if (type == Integer.TYPE) {
                out.setInt(name, (Integer)value);
                continue;
            }
            if (type == Integer.class) {
                out.setInt(name, (Integer)value);
                continue;
            }
            if (type == Long.TYPE) {
                out.setLong(name, (Long)value);
                continue;
            }
            if (type == Long.class) {
                out.setLong(name, (Long)value);
                continue;
            }
            if (type == Float.TYPE) {
                out.setFloat(name, ((Float)value).floatValue());
                continue;
            }
            if (type == Float.class) {
                out.setFloat(name, ((Float)value).floatValue());
                continue;
            }
            if (type == Double.TYPE) {
                out.setDouble(name, (Double)value);
                continue;
            }
            if (type == Double.class) {
                out.setDouble(name, (Double)value);
                continue;
            }
            if (type == Boolean.TYPE) {
                out.setBoolean(name, (Boolean)value);
                continue;
            }
            if (type == Boolean.class) {
                out.setBoolean(name, (Boolean)value);
                continue;
            }
            if (type == String.class) {
                out.setString(name, (String)value);
                continue;
            }
            if (type == Date.class) {
                out.setDate(name, (Date)value);
                continue;
            }
            out.setString(name, String.valueOf(value));
        }
        return out;
    }

    public static void propertiesToPojo(IProperties from, Object to) throws IOException {
        MPojo.propertiesToPojo(from, to, MPojo.getDefaultModelFactory(), null);
    }

    public static void propertiesToPojo(IProperties from, Object to, PojoModelFactory factory) throws IOException {
        MPojo.propertiesToPojo(from, to, factory, null);
    }

    public static void propertiesToPojo(IProperties from, Object to, PojoModelFactory factory, Caster<Object, Object> unknownHadler) throws IOException {
        PojoModel model = factory.createPojoModel(to.getClass());
        for (PojoAttribute attr : model) {
            String name = attr.getName();
            Class<?> type = attr.getType();
            try {
                if (!from.isProperty(name) || !attr.canWrite()) continue;
                if (type == Boolean.class || type == Boolean.TYPE) {
                    attr.set(to, from.getBoolean(name, false));
                    continue;
                }
                if (type == Integer.class || type == Integer.TYPE) {
                    attr.set(to, from.getInt(name, 0));
                    continue;
                }
                if (type == String.class) {
                    attr.set(to, from.getString(name, null));
                    continue;
                }
                if (type == UUID.class) {
                    try {
                        attr.set(to, UUID.fromString(from.getString(name)));
                    }
                    catch (IllegalArgumentException e) {
                        attr.set(to, null);
                    }
                    continue;
                }
                if (type.isEnum()) {
                    Object c;
                    ?[] cons = type.getEnumConstants();
                    int ord = from.getInt(name, 0);
                    Object t = c = cons.length > 0 ? (Object)cons[0] : null;
                    if (ord >= 0 && ord < cons.length) {
                        c = cons[ord];
                    }
                    attr.set(to, c);
                    continue;
                }
                attr.set(to, unknownHadler == null ? from.getString(name) : unknownHadler.cast(from.getProperty(name), null));
            }
            catch (Throwable t) {
                System.out.println("ERROR " + name);
                t.printStackTrace();
            }
        }
    }
}

