/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.parser;

import java.util.Iterator;

public class StringTokenizerParser
implements Iterable<String>,
Iterator<String> {
    private String part;
    private String condition;
    protected String breakableCharacters = "";
    protected String enclosureCharacters = "\"'";
    protected String whiteSpace = " \r\t";
    protected String encapsulateCharacters = "\\";
    protected String lineSeparator = "\n";
    protected char enclosure;
    protected char encapsulated;
    protected StringBuffer buffer;
    private int line = 0;
    private char current;
    private String original;

    public StringTokenizerParser(String condition) {
        this.original = condition;
        this.condition = condition = condition.trim();
    }

    public void parseToken() {
        do {
            this.findNextToken();
            if (this.part == null) {
                return;
            }
            this.part = this.part.trim();
        } while (this.part.length() == 0);
    }

    protected void findNextToken() {
        this.part = null;
        if (this.condition == null) {
            return;
        }
        this.enclosure = '\u0000';
        this.encapsulated = '\u0000';
        this.buffer = new StringBuffer();
        for (int i = 0; i < this.condition.length(); ++i) {
            this.current = this.condition.charAt(i);
            if (this.encapsulated != '\u0000') {
                this.foundEncapsulated();
                continue;
            }
            if (this.enclosure != '\u0000' && this.current == this.enclosure) {
                this.foundToken(i);
                return;
            }
            if (this.isEnclosureCharacter()) {
                this.enclosure = this.current;
            } else {
                if (this.isWhiteSpace()) {
                    this.foundToken(i);
                    return;
                }
                if (this.isEndOfLine()) {
                    ++this.line;
                    this.foundToken(i);
                    return;
                }
            }
            if (this.isEncapsulateStarting()) {
                this.encapsulated = this.current;
                continue;
            }
            if (this.breakOnThisCharacter()) {
                this.foundBreak(i);
                return;
            }
            this.foundCharacter();
        }
        this.foundEnd();
    }

    protected void foundBreak(int i) {
        if (i == 0) {
            this.buffer.append(this.current);
            this.foundToken(i);
        } else {
            this.foundToken(i - 1);
        }
    }

    protected void foundEnd() {
        this.part = this.buffer.toString();
        this.condition = null;
    }

    protected void foundToken(int i) {
        this.part = this.buffer.toString();
        this.condition = this.condition.substring(i + 1);
    }

    protected boolean isEncapsulateStarting() {
        return this.encapsulateCharacters.indexOf(this.current) >= 0;
    }

    protected void foundEncapsulated() {
        this.buffer.append(this.current);
        this.encapsulated = '\u0000';
    }

    protected void foundCharacter() {
        this.buffer.append(this.current);
    }

    protected boolean isWhiteSpace() {
        return this.whiteSpace.indexOf(this.current) >= 0;
    }

    protected boolean isEndOfLine() {
        return this.lineSeparator.indexOf(this.current) >= 0;
    }

    protected boolean isEnclosureCharacter() {
        return this.enclosureCharacters.indexOf(this.current) >= 0;
    }

    protected boolean breakOnThisCharacter() {
        return this.breakableCharacters.indexOf(this.current) >= 0;
    }

    public String getBreakableCharacters() {
        return this.breakableCharacters;
    }

    public void setBreakableCharacters(String breakableCharacters) {
        this.breakableCharacters = breakableCharacters;
    }

    public String getEnclosureCharacters() {
        return this.enclosureCharacters;
    }

    public void setEnclosureCharacters(String enclosureCharacters) {
        this.enclosureCharacters = enclosureCharacters;
    }

    public String getWhiteSpace() {
        return this.whiteSpace;
    }

    public void setWhiteSpace(String whiteSpace) {
        this.whiteSpace = whiteSpace;
    }

    public String getEncapsulateCharacters() {
        return this.encapsulateCharacters;
    }

    public void setEncapsulateCharacters(String encapsulateCharacters) {
        this.encapsulateCharacters = encapsulateCharacters;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    @Override
    public boolean hasNext() {
        return this.condition != null;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    protected void reset() {
        this.condition = this.original;
        this.part = null;
        this.enclosure = '\u0000';
        this.encapsulated = '\u0000';
        this.buffer = null;
        this.line = 0;
    }

    @Override
    public String next() {
        this.parseToken();
        return this.part;
    }

    @Override
    public void remove() {
    }

    public boolean isTokenEncapsulated() {
        return this.encapsulated != '\u0000';
    }
}

