/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.parser;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.MXml;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Hashtable;
import java.util.Map;

public class HtmlParser {
    public static final int TEXT = 1;
    public static final int TAG = 2;
    private Reader is = null;
    private Listener listener = null;
    private boolean trim = false;

    public HtmlParser() {
    }

    public HtmlParser(InputStream _is, Listener _listener) {
        this.is = new InputStreamReader(_is);
        this.listener = _listener;
    }

    public HtmlParser(Reader _is, Listener _listener) {
        this.is = _is;
        this.listener = _listener;
    }

    public boolean parse(Reader _is, Listener _listener) {
        this.is = _is;
        this.listener = _listener;
        return this.parse();
    }

    public boolean parse() {
        int type = 1;
        StringBuffer text = new StringBuffer();
        char[] one = new char[1];
        try {
            int i;
            while ((i = this.is.read(one)) == 1) {
                char c = one[0];
                switch (type) {
                    case 1: {
                        if (c == '<') {
                            type = 2;
                            this.trim(text);
                            if (text.length() > 0 && !this.listener.foundText(MXml.decode(text.toString()))) {
                                return false;
                            }
                            text = new StringBuffer();
                            break;
                        }
                        text.append(c);
                        break;
                    }
                    case 2: {
                        if (c == '>') {
                            type = 1;
                            String tag = text.toString().trim();
                            if (tag.length() > 0) {
                                String tagx;
                                if (tag.startsWith("!--") && tag.endsWith("--") ? !this.listener.foundNote(tag.substring(3, tag.length() - 2)) : (tag.startsWith("?") && tag.endsWith("?") ? !this.listener.foundProcessorInstruction(tag.substring(1, tag.length() - 1).trim()) : (tag.startsWith("/") ? !this.listener.foundTagClose(tag.substring(1).trim()) : (tag.endsWith("/") ? !this.listener.foundSingleTag(this.getTagName(tagx = tag.substring(0, tag.length() - 1).trim()), this.getTagParams(tagx)) : !this.listener.foundTagOpen(this.getTagName(tag), this.getTagParams(tag)))))) {
                                    return false;
                                }
                            } else {
                                System.err.println("Tag without name");
                                return true;
                            }
                            text = new StringBuffer();
                            break;
                        }
                        text.append(c);
                    }
                }
            }
            if (type == 1) {
                this.trim(text);
                if (text.length() > 0 && !this.listener.foundText(MXml.decode(text.toString()))) {
                    return false;
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return true;
        }
        return true;
    }

    protected void trim(StringBuffer text) {
        if (!this.trim) {
            return;
        }
        while (text.length() > 0 && MString.isWhitespace(text.charAt(0))) {
            text.deleteCharAt(0);
        }
        while (text.length() > 0 && MString.isWhitespace(text.charAt(text.length() - 1))) {
            text.deleteCharAt(text.length() - 1);
        }
    }

    private String getTagName(String tag) {
        if (MString.isIndex(tag, MString.WHITESPACE)) {
            return MString.beforeIndex(tag, MString.WHITESPACE);
        }
        return tag;
    }

    private Hashtable<String, String> getTagParams(String tag) {
        Hashtable<String, String> out = new Hashtable<String, String>();
        if (!MString.isIndex(tag, MString.WHITESPACE)) {
            return out;
        }
        String tagx = MString.afterIndex(tag, MString.WHITESPACE);
        while (tagx.length() != 0) {
            int pos = tagx.indexOf(61);
            if (pos < 0) {
                return out;
            }
            String key = tagx.substring(0, pos).trim();
            tagx = tagx.substring(pos + 1);
            int pos1 = tagx.indexOf(34);
            int pos2 = tagx.indexOf(39);
            pos = pos1 < 0 ? pos2 : (pos2 < 0 ? pos1 : (pos2 < pos1 ? pos2 : pos1));
            if (pos < 0) {
                return out;
            }
            if ((pos = (tagx = tagx.substring(pos + 1)).indexOf(pos == pos1 ? 34 : 39)) < 0) {
                return out;
            }
            out.put(MXml.decode(key), MXml.decode(tagx.substring(0, pos)));
            tagx = tagx.substring(pos + 1);
        }
        return out;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public static interface Listener {
        public boolean foundText(String var1);

        public boolean foundNote(String var1);

        public boolean foundProcessorInstruction(String var1);

        public boolean foundTagClose(String var1);

        public boolean foundSingleTag(String var1, Map<String, String> var2);

        public boolean foundTagOpen(String var1, Map<String, String> var2);
    }
}

