/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.logging;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.LogEngine;
import de.mhus.lib.core.logging.LogFactory;
import java.io.PrintWriter;
import java.util.Date;

public class PrintWriterLog
extends Log {
    private PrintWriter out;
    private String name;
    private boolean printTime = true;
    private Log.LEVEL level = Log.LEVEL.TRACE;
    private boolean traces = true;

    public PrintWriterLog(String name, PrintWriter writer) {
        super(name);
        this.out = writer;
        this.engine = new MyEngine(name);
    }

    public String printTime() {
        if (this.printTime) {
            return MCast.toString(new Date()) + " ";
        }
        return "";
    }

    public Log.LEVEL getLevel() {
        return this.level;
    }

    public void setLevel(Log.LEVEL level) {
        this.level = level;
    }

    public boolean isTraces() {
        return this.traces;
    }

    public void setTraces(boolean traces) {
        this.traces = traces;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    @Override
    public void update() {
    }

    @Override
    protected void register() {
    }

    @Override
    public void unregister() {
    }

    private class MyEngine
    extends LogEngine {
        public MyEngine(String name) {
            super(name);
        }

        @Override
        public void debug(Object message) {
            if (!this.isDebugEnabled()) {
                return;
            }
            PrintWriterLog.this.out.println(PrintWriterLog.this.printTime() + "DEBUG: " + PrintWriterLog.this.name + " " + message);
            if (message != null && message instanceof Throwable) {
                ((Throwable)message).printStackTrace(PrintWriterLog.this.out);
            }
        }

        @Override
        public void debug(Object message, Throwable t) {
            if (!this.isDebugEnabled()) {
                return;
            }
            PrintWriterLog.this.out.println(PrintWriterLog.this.printTime() + "DEBUG: " + PrintWriterLog.this.name + " " + message);
            if (t != null && PrintWriterLog.this.traces) {
                t.printStackTrace(PrintWriterLog.this.out);
            }
        }

        @Override
        public void error(Object message) {
            if (!this.isErrorEnabled()) {
                return;
            }
            PrintWriterLog.this.out.println(PrintWriterLog.this.printTime() + "ERROR: " + PrintWriterLog.this.name + " " + message);
            if (message != null && message instanceof Throwable && PrintWriterLog.this.traces) {
                ((Throwable)message).printStackTrace(PrintWriterLog.this.out);
            }
        }

        @Override
        public void error(Object message, Throwable t) {
            if (!this.isErrorEnabled()) {
                return;
            }
            PrintWriterLog.this.out.println(PrintWriterLog.this.printTime() + "ERROR: " + PrintWriterLog.this.name + " " + message);
            if (t != null && PrintWriterLog.this.traces) {
                t.printStackTrace(PrintWriterLog.this.out);
            }
        }

        @Override
        public void fatal(Object message) {
            if (!this.isFatalEnabled()) {
                return;
            }
            PrintWriterLog.this.out.println(PrintWriterLog.this.printTime() + "FATAL: " + PrintWriterLog.this.name + " " + message);
            if (message != null && message instanceof Throwable && PrintWriterLog.this.traces) {
                ((Throwable)message).printStackTrace(PrintWriterLog.this.out);
            }
        }

        @Override
        public void fatal(Object message, Throwable t) {
            if (!this.isFatalEnabled()) {
                return;
            }
            PrintWriterLog.this.out.println(PrintWriterLog.this.printTime() + "FATAL: " + PrintWriterLog.this.name + " " + message);
            if (t != null && PrintWriterLog.this.traces) {
                t.printStackTrace(PrintWriterLog.this.out);
            }
        }

        @Override
        public void info(Object message) {
            if (!this.isInfoEnabled()) {
                return;
            }
            PrintWriterLog.this.out.println(PrintWriterLog.this.printTime() + "INFO : " + PrintWriterLog.this.name + " " + message);
            if (message != null && message instanceof Throwable && PrintWriterLog.this.traces) {
                ((Throwable)message).printStackTrace(PrintWriterLog.this.out);
            }
        }

        @Override
        public void info(Object message, Throwable t) {
            if (!this.isInfoEnabled()) {
                return;
            }
            PrintWriterLog.this.out.println(PrintWriterLog.this.printTime() + "INFO : " + PrintWriterLog.this.name + " " + message);
            if (t != null && PrintWriterLog.this.traces) {
                t.printStackTrace(PrintWriterLog.this.out);
            }
        }

        @Override
        public boolean isDebugEnabled() {
            return PrintWriterLog.this.level.ordinal() <= Log.LEVEL.DEBUG.ordinal();
        }

        @Override
        public boolean isErrorEnabled() {
            return PrintWriterLog.this.level.ordinal() <= Log.LEVEL.ERROR.ordinal();
        }

        @Override
        public boolean isFatalEnabled() {
            return PrintWriterLog.this.level.ordinal() <= Log.LEVEL.FATAL.ordinal();
        }

        @Override
        public boolean isInfoEnabled() {
            return PrintWriterLog.this.level.ordinal() <= Log.LEVEL.INFO.ordinal();
        }

        @Override
        public boolean isTraceEnabled() {
            return PrintWriterLog.this.level.ordinal() <= Log.LEVEL.TRACE.ordinal();
        }

        @Override
        public boolean isWarnEnabled() {
            return PrintWriterLog.this.level.ordinal() <= Log.LEVEL.WARN.ordinal();
        }

        @Override
        public void trace(Object message) {
            if (this.isTraceEnabled()) {
                PrintWriterLog.this.out.println(PrintWriterLog.this.printTime() + "TRACE: " + PrintWriterLog.this.name + " " + message);
                if (message != null && message instanceof Throwable && PrintWriterLog.this.traces) {
                    ((Throwable)message).printStackTrace(PrintWriterLog.this.out);
                }
            }
        }

        @Override
        public void trace(Object message, Throwable t) {
            if (!this.isTraceEnabled()) {
                return;
            }
            PrintWriterLog.this.out.println(PrintWriterLog.this.printTime() + "TRACE: " + PrintWriterLog.this.name + " " + message);
            if (t != null && PrintWriterLog.this.traces) {
                t.printStackTrace(PrintWriterLog.this.out);
            }
        }

        @Override
        public void warn(Object message) {
            if (!this.isWarnEnabled()) {
                return;
            }
            PrintWriterLog.this.out.println(PrintWriterLog.this.printTime() + "WARN : " + PrintWriterLog.this.name + " " + message);
            if (message != null && message instanceof Throwable && PrintWriterLog.this.traces) {
                ((Throwable)message).printStackTrace(PrintWriterLog.this.out);
            }
        }

        @Override
        public void warn(Object message, Throwable t) {
            if (!this.isWarnEnabled()) {
                return;
            }
            PrintWriterLog.this.out.println(PrintWriterLog.this.printTime() + "WARN : " + PrintWriterLog.this.name + " " + message);
            if (t != null && PrintWriterLog.this.traces) {
                t.printStackTrace(PrintWriterLog.this.out);
            }
        }

        @Override
        public void doInitialize(LogFactory logFactory) {
        }

        @Override
        public void close() {
        }
    }
}

