/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.logging;

import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.logging.LevelMapper;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.TrailLevelMapper;
import de.mhus.lib.core.system.ISingleton;

public class MLogUtil {
    private static Log log = Log.getLog(MLogUtil.class);

    public static Log log() {
        return log;
    }

    public static void setTrailConfig() {
        MLogUtil.setTrailConfig(null);
    }

    public static void setTrailConfig(String parameters) {
        ISingleton singleton = MSingleton.get();
        LevelMapper mapper = singleton.getLogFactory().getLevelMapper();
        if (mapper != null && mapper instanceof TrailLevelMapper) {
            TrailLevelMapper m = (TrailLevelMapper)mapper;
            m.doConfigureTrail(parameters);
        }
    }

    public static String getTrailConfig() {
        ISingleton singleton = MSingleton.get();
        LevelMapper mapper = singleton.getLogFactory().getLevelMapper();
        if (mapper != null && mapper instanceof TrailLevelMapper) {
            TrailLevelMapper m = (TrailLevelMapper)mapper;
            return m.doSerializeTrail();
        }
        return null;
    }

    public static void releaseTrailConfig() {
        ISingleton singleton = MSingleton.get();
        LevelMapper mapper = singleton.getLogFactory().getLevelMapper();
        if (mapper != null && mapper instanceof TrailLevelMapper) {
            TrailLevelMapper m = (TrailLevelMapper)mapper;
            m.doResetTrail();
        }
    }

    public static boolean isTrailLevelMapper() {
        ISingleton singleton = MSingleton.get();
        LevelMapper mapper = singleton.getLogFactory().getLevelMapper();
        return mapper != null && mapper instanceof TrailLevelMapper;
    }

    public static void logStackTrace(Log log, String prefix, StackTraceElement[] stackTrace) {
        for (StackTraceElement element : stackTrace) {
            log.w(prefix, "  " + element);
        }
    }
}

