/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.logging;

import de.mhus.lib.annotations.activator.DefaultImplementation;
import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.lang.IBase;
import de.mhus.lib.core.logging.ConsoleFactory;
import de.mhus.lib.core.logging.LevelMapper;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.LogEngine;
import de.mhus.lib.core.logging.ParameterMapper;
import de.mhus.lib.core.service.ConfigProvider;
import java.util.WeakHashMap;

@DefaultImplementation(value=ConsoleFactory.class)
public abstract class LogFactory
implements IBase {
    WeakHashMap<String, LogEngine> buffer = new WeakHashMap();
    protected Log.LEVEL level = Log.LEVEL.INFO;
    protected LevelMapper levelMapper;
    private ParameterMapper parameterMapper;

    public LogEngine getInstance(Class<?> clazz) {
        return this.getInstance(clazz.getCanonicalName());
    }

    public abstract void init(ResourceNode var1) throws Exception;

    public void init() throws Exception {
        ResourceNode config = MSingleton.get().getBaseControl().base(this).lookup(ConfigProvider.class).getConfig(this, null);
        this.init(config);
    }

    public synchronized LogEngine getInstance(String name) {
        LogEngine inst = this.buffer.get(name);
        if (inst == null) {
            inst = this.createInstance(name);
            inst.doInitialize(this);
            this.buffer.put(name, inst);
        }
        return inst;
    }

    public abstract LogEngine createInstance(String var1);

    public LogEngine getLog(Class<?> class1) {
        return this.getInstance(class1);
    }

    public void setDefaultLevel(Log.LEVEL level) {
        this.level = level;
    }

    public Log.LEVEL getDefaultLevel() {
        return this.level;
    }

    public LevelMapper getLevelMapper() {
        return this.levelMapper;
    }

    public void setLevelMapper(LevelMapper levelMapper) {
        this.levelMapper = levelMapper;
    }

    public ParameterMapper getParameterMapper() {
        return this.parameterMapper;
    }

    public void setParameterMapper(ParameterMapper parameterMapper) {
        this.parameterMapper = parameterMapper;
    }
}

