/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.logging;

import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.MSystem;
import de.mhus.lib.core.logging.LevelMapper;
import de.mhus.lib.core.logging.LogEngine;
import de.mhus.lib.core.logging.ParameterMapper;
import java.util.UUID;

public class Log {
    protected boolean localTrace = true;
    protected String name;
    protected LevelMapper levelMapper;
    protected ParameterMapper parameterMapper;
    protected LogEngine engine = null;
    protected UUID id = UUID.randomUUID();

    public Log(Object owner) {
        String name = null;
        if (owner == null) {
            name = "?";
        } else if (owner instanceof Class) {
            name = ((Class)owner).getName();
        } else {
            name = String.valueOf(owner);
            if (name == null) {
                name = owner.getClass().getCanonicalName();
            }
        }
        this.name = name;
        this.localTrace = MSingleton.isTrace(name);
        this.update();
        this.register();
    }

    protected void register() {
        MSingleton.registerLogger(this);
    }

    protected void unregister() {
        MSingleton.unregisterLogger(this);
    }

    public void t(Object ... msg) {
        this.log(LEVEL.TRACE, msg);
    }

    public void log(LEVEL level, Object ... msg) {
        if (this.engine == null) {
            return;
        }
        if (this.levelMapper != null) {
            level = this.levelMapper.map(this, level, msg);
        }
        switch (level) {
            case DEBUG: {
                if (this.engine.isDebugEnabled()) break;
                return;
            }
            case ERROR: {
                if (this.engine.isErrorEnabled()) break;
                return;
            }
            case FATAL: {
                if (this.engine.isFatalEnabled()) break;
                return;
            }
            case INFO: {
                if (this.engine.isInfoEnabled()) break;
                return;
            }
            case TRACE: {
                if (this.engine.isTraceEnabled()) break;
                return;
            }
            case WARN: {
                if (this.engine.isWarnEnabled()) break;
                return;
            }
            default: {
                return;
            }
        }
        if (this.parameterMapper != null) {
            msg = this.parameterMapper.map(this, msg);
        }
        StringBuffer sb = new StringBuffer();
        this.prepare(sb);
        Throwable error = null;
        for (Object o : msg) {
            error = this.serialize(sb, o, error);
        }
        switch (level) {
            case DEBUG: {
                this.engine.debug(sb.toString(), error);
                break;
            }
            case ERROR: {
                this.engine.error(sb.toString(), error);
                break;
            }
            case FATAL: {
                this.engine.fatal(sb.toString(), error);
                break;
            }
            case INFO: {
                this.engine.info(sb.toString(), error);
                break;
            }
            case TRACE: {
                this.engine.trace(sb.toString(), error);
                break;
            }
            case WARN: {
                this.engine.warn(sb.toString(), error);
                break;
            }
        }
    }

    private Throwable serialize(StringBuffer sb, Object o, Throwable error) {
        try {
            if (o == null) {
                sb.append("[null]");
            } else if (o instanceof Throwable) {
                if (error == null) {
                    return (Throwable)o;
                }
                sb.append("[").append(o).append("]");
            } else if (o.getClass().isArray()) {
                sb.append("{");
                for (Object p : (Object[])o) {
                    error = this.serialize(sb, p, error);
                }
                sb.append("}");
            } else {
                sb.append("[").append(o).append("]");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return error;
    }

    public void d(Object ... msg) {
        this.log(LEVEL.DEBUG, msg);
    }

    public void i(Object ... msg) {
        this.log(LEVEL.INFO, msg);
    }

    public void w(Object ... msg) {
        this.log(LEVEL.WARN, msg);
    }

    public void e(Object ... msg) {
        this.log(LEVEL.ERROR, msg);
    }

    public void f(Object ... msg) {
        this.log(LEVEL.FATAL, msg);
    }

    protected void prepare(StringBuffer sb) {
        if (this.levelMapper != null) {
            this.levelMapper.prepareMessage(this, sb);
        } else {
            sb.append('[').append(Thread.currentThread().getId()).append(']');
        }
    }

    public void setLocalTrace(boolean localTrace) {
        this.localTrace = localTrace;
    }

    public boolean isLocalTrace() {
        return this.localTrace;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return MSystem.toString(this, this.getName());
    }

    public static Log getLog(Object owner) {
        return new Log(owner);
    }

    public void update() {
        this.engine = MSingleton.get().getLogFactory().getInstance(this.getName());
        this.localTrace = MSingleton.isTrace(this.name);
        this.levelMapper = MSingleton.get().getLogFactory().getLevelMapper();
        this.parameterMapper = MSingleton.get().getLogFactory().getParameterMapper();
    }

    public ParameterMapper getParameterMapper() {
        return this.parameterMapper;
    }

    public boolean isLevelEnabled(LEVEL level) {
        if (this.engine == null) {
            return false;
        }
        if (this.localTrace) {
            level = LEVEL.INFO;
        } else if (this.levelMapper != null) {
            level = this.levelMapper.map(this, level, new Object[0]);
        }
        switch (level) {
            case DEBUG: {
                return this.engine.isDebugEnabled();
            }
            case ERROR: {
                return this.engine.isErrorEnabled();
            }
            case FATAL: {
                return this.engine.isFatalEnabled();
            }
            case INFO: {
                return this.engine.isInfoEnabled();
            }
            case TRACE: {
                return this.engine.isTraceEnabled();
            }
            case WARN: {
                return this.engine.isWarnEnabled();
            }
        }
        return false;
    }

    public void close() {
        if (this.engine == null) {
            return;
        }
        this.unregister();
        this.engine.close();
        this.engine = null;
    }

    public UUID getId() {
        return this.id;
    }

    public static enum LEVEL {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR,
        FATAL;

    }
}

